package com.bcxin.tenant.bcx.rest.apis.controllers.requests;

import lombok.Data;

import java.util.Collection;

@Data
public class FlushDb2RedisRequest extends RequestAbstract {
    private Collection<ContentRequest> contents;
    private boolean reload;
    private boolean clearRails;
    private boolean autoUpdatedExpired;


    public static enum DataType {
        Company,
        Employee,
        Station,
        StationPersonRelative,

        /**
         * 考场
         */
        ExamRoom,
        /**
         * 考试点
         */
        ExamSite,
        /**
         * 考试
         */
        SystemExamInfo,
        RefreshCompanyPoints,
        RefreshCompanyDesks,
        User,
        CommunityUser,
        DispatchDataScope,
        SuperviseDeparts,

        TemporaryProtectionProject,
        TemporaryProtectionProjectGroup,
        TemporaryProtectionProjectMember,
        Device,
        TemporaryProtectionProjectPersonType,

        EventOrganizerJoinProject,
        EventOrganizerStationManager,
        DispatchDataSource,
        Member,
        EventOrganizerLimitedResource
    }

    @Data
    public static class ContentRequest extends RequestAbstract {
        private DataType dataType;
        private Collection<String> ids;
    }
}
