package com.bcxin.tenant.bcx.rest.apis.controllers;

import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.jdks.ProjectMetaRpcProvider;
import com.bcxin.tenant.bcx.jdks.requests.metas.ProjectMetaRequest;
import com.bcxin.tenant.bcx.jdks.requests.metas.ProjectMetaSearchRequest;
import com.bcxin.tenant.bcx.jdks.responses.metas.ProjectMetaResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Tag(name = "ProjectMetaController", description = "通用数据查询")
@RestController
@RequestMapping("/meta/projects")
public class ProjectMetaController extends ControllerAbstract{
    private final ProjectMetaRpcProvider rpcProvider;

    public ProjectMetaController(ProjectMetaRpcProvider rpcProvider) {
        this.rpcProvider = rpcProvider;
    }

    @Operation(
            summary = "新增项目",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @PostMapping("")
    public void doPost(@RequestBody ProjectMetaRequest request) {
        this.rpcProvider.create(request);
    }

    @Operation(
            summary = "编辑项目",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @PutMapping("/{id}")
    public void doPut(@PathVariable String id,@RequestBody ProjectMetaRequest request) {
        this.rpcProvider.update(id, request);
    }

    @Operation(
            summary = "删除项目",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @DeleteMapping("/{id}")
    public void doDelete(@PathVariable String id) {
        this.rpcProvider.delete(id);
    }

    @Operation(
            summary = "批量删除项目",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @DeleteMapping("/batch")
    public void doBatchDelete(@RequestBody java.util.List<String> ids) {
        this.rpcProvider.batchDelete(ids);
    }

    @Operation(
            summary = "高级搜索",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @PostMapping("/search")
    public ResponseEntity<EntityCollection<ProjectMetaResponse>> doSearch(@RequestBody ProjectMetaSearchRequest request) {
        var data = this.rpcProvider.search(request);

        return this.ok(data);
    }

    @Operation(
            summary = "获取详情",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @GetMapping("/{id}")
    public ResponseEntity<ProjectMetaResponse> doGet(@PathVariable String id) {
        var data = this.rpcProvider.getById(id);

        return this.ok(data);
    }
}
