package com.bcxin.tenant.bcx.rest.apis.controllers;

import com.bcxin.tenant.bcx.jdks.PageMetaSettingRpcProvider;
import com.bcxin.tenant.bcx.jdks.requests.metas.PageMetaSettingRequest;
import com.bcxin.tenant.bcx.jdks.responses.metas.PageSettingResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

@Tag(name = "PageMetaSettingController", description = "页面元数据管理")
@RestController
@RequestMapping("/meta/page-settings")
public class PageMetaSettingController extends ControllerAbstract {

    private final PageMetaSettingRpcProvider pageMetaSettingRpcProvider;

    public PageMetaSettingController(PageMetaSettingRpcProvider pageMetaSettingRpcProvider) {
        this.pageMetaSettingRpcProvider = pageMetaSettingRpcProvider;
    }


    @Operation(
            summary = "搜索",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @PostMapping("/search")
    public ResponseEntity<PageSettingResponse> doSearch() {
        PageSettingResponse data = this.pageMetaSettingRpcProvider.getSetting();

        return this.ok(data);
    }

    @Operation(
            summary = "新增页面配置",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @PostMapping("/batch")
    public ResponseEntity doPost(@RequestBody Collection<PageMetaSettingRequest> request) {
        this.pageMetaSettingRpcProvider.batch(request);

        return this.ok();
    }

    @Operation(
            summary = "修改页面配置",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @PutMapping("/{id}")
    public ResponseEntity doPut(
            @PathVariable String id,
            @RequestBody PageMetaSettingRequest request) {
        this.pageMetaSettingRpcProvider.update(id, request);

        return this.ok();
    }

}