package com.bcxin.tenant.bcx.rest.apis.controllers;

import com.bcxin.tenant.bcx.jdks.ExamSubjectRpcProvider;
import com.bcxin.tenant.bcx.jdks.requests.examSubjects.ExamSubjectSearchRequest;
import com.bcxin.tenant.bcx.jdks.responses.commons.CommonSettingResponse;
import com.bcxin.tenant.bcx.jdks.responses.examSubjects.ExamSubjectResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;

@Tag(name = "ExamSubjectController", description = "考务科目")
@RestController
@RequestMapping("/exam-subjects")
public class ExamSubjectController extends ControllerAbstract {

    private final ExamSubjectRpcProvider rpcProvider;

    public ExamSubjectController(ExamSubjectRpcProvider rpcProvider) {
        this.rpcProvider = rpcProvider;
    }

    @PostMapping("/search")
    public ResponseEntity<Collection<ExamSubjectResponse>> doSearch(@RequestBody ExamSubjectSearchRequest request) {
        Collection<ExamSubjectResponse> data = this.rpcProvider.search(request);

        return this.ok(data);
    }
}
