package com.bcxin.tenant.bcx.rest.apis.controllers;

import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.jdks.ExamEnrollmentCriteriaRpcProvider;
import com.bcxin.tenant.bcx.jdks.requests.examEnrollmentCriterias.CreateExamEnrollmentCriteriaRequest;
import com.bcxin.tenant.bcx.jdks.requests.examEnrollmentCriterias.ExamEnrollmentCriteriaSearchRequest;
import com.bcxin.tenant.bcx.jdks.responses.examEnrollmentCriterias.ExamEnrollmentCriteriaResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.UUID;

/**
 * 自定义报名功能
 */
@Tag(name = "ExamEnrollmentCriteriaController", description = "自定义报名功能")
@RestController
@RequestMapping("/bus/exam-enrollment-criteria")
public class ExamEnrollmentCriteriaController extends ControllerAbstract {
    private final ExamEnrollmentCriteriaRpcProvider rpcProvider;
    public ExamEnrollmentCriteriaController(ExamEnrollmentCriteriaRpcProvider rpcProvider) {
        this.rpcProvider = rpcProvider;
    }

    @Operation(
            summary = "新增自定义报名条件",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @PostMapping("")
    public ResponseEntity doPost(@RequestBody CreateExamEnrollmentCriteriaRequest request) {
        request.setSlug(UUID.randomUUID().toString());
        String id = this.rpcProvider.create(request);

        return this.ok(id);
    }

    @Operation(
            summary = "编辑自定义报名条件",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @PutMapping("/{id}")
    public ResponseEntity doPut(@PathVariable String id,@RequestBody CreateExamEnrollmentCriteriaRequest request) {
        this.rpcProvider.update(id, request);

        return this.ok();
    }

    @Operation(
            summary = "删除项目",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @DeleteMapping("/{id}")
    public ResponseEntity doDelete(@PathVariable String id) {
        this.rpcProvider.delete(id);

        return this.ok();
    }

    @Operation(
            summary = "高级搜索",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @PostMapping("/search")
    public ResponseEntity<EntityCollection<ExamEnrollmentCriteriaResponse>> doSearch(@RequestBody ExamEnrollmentCriteriaSearchRequest request) {
        var data = this.rpcProvider.search(request);

        return this.ok(data);
    }

    @Operation(
            summary = "获取详情",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @GetMapping("/{id}")
    public ResponseEntity<ExamEnrollmentCriteriaResponse> doGet(@PathVariable String id) {
        var data = this.rpcProvider.getById(id);

        return this.ok(data);
    }
}
