package com.bcxin.tenant.bcx.rest.apis.controllers;

import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.enums.DoActionType;
import com.bcxin.tenant.bcx.infrastructures.valueTypes.DynamicConditionFieldValueType;
import com.bcxin.tenant.bcx.jdks.PageDataRpcProvider;
import com.bcxin.tenant.bcx.jdks.requests.examEnrollmentUsers.ReplenishExamEnrollmentUserRequest;
import com.bcxin.tenant.bcx.jdks.requests.pages.MappingPageDataSearchRequest;
import com.bcxin.tenant.bcx.jdks.requests.pages.PageDataActionRequest;
import com.bcxin.tenant.bcx.jdks.requests.pages.PageDataRequest;
import com.bcxin.tenant.bcx.jdks.responses.pages.PageDataResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 报名数据
 */
@Tag(name = "CurrentUserController", description = "当前用户信息")
@RestController
@RequestMapping("/current")
public class CurrentUserController extends ControllerAbstract{
    private final PageDataRpcProvider rpcProvider;

    public CurrentUserController(PageDataRpcProvider rpcProvider) {
        this.rpcProvider = rpcProvider;
    }

    @Operation(
            summary = "获取待完善的个人报名列表",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @RequestMapping(value = "/exam-enrollment-users/pending",method = {RequestMethod.POST, RequestMethod.GET})
    public ResponseEntity doPendingSearch(@RequestBody(required = false) MappingPageDataSearchRequest request) {
        if(request==null) {
            request = new MappingPageDataSearchRequest();
        }

        request.setMappingId("dynamic_exam_user_data_00001");
        request.getFields().add(DynamicConditionFieldValueType.create(
                "u.confirm_status",
                0,
                "eq"
        ));
        request.setPageSize(1000);

        EntityCollection<PageDataResponse> rps = this.rpcProvider.search(request);

        return this.ok(rps);
    }

    @Operation(
            summary = "获取待完善的个人报名列表",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @PostMapping("/exam-enrollment-users/search")
    public ResponseEntity doSearch(MappingPageDataSearchRequest request) {
        request.setMappingId("dynamic_exam_user_data_00001");
        request.getFields().add(DynamicConditionFieldValueType.create(
                "u.confirm_status",
                Stream.of(0, 1, 2, 3).collect(Collectors.toList()),
                "in"
        ));
        EntityCollection<PageDataResponse> rps = this.rpcProvider.search(request);

        return this.ok(rps);
    }

    @Operation(
            summary = "确认及补充完善资料信息",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回系统的 dispatchToken."),
                    @ApiResponse(responseCode = "401", description = "无效用户返回401."),
                    @ApiResponse(responseCode = "403", description = "禁止使用的企业, 该接口返回403."),
            }
    )
    @PutMapping("/exam-enrollment-users/replenish")
    public ResponseEntity doConfirm(@RequestBody ReplenishExamEnrollmentUserRequest request) {
        PageDataRequest pageDataRequest = new PageDataRequest();
        pageDataRequest.setPageId(request.getPageId());
        pageDataRequest.setItems(request.getItems());
        /**
         * 确认数据
         * 如果当前 confirm_status 为 3，则不重置为 1
         */
        Object currentConfirmStatus = request.getItems() != null ? request.getItems().get("confirm_status") : null;
        if (currentConfirmStatus == null || !currentConfirmStatus.equals(3)) {
            pageDataRequest.getItems().put("confirm_status", 1);
        }

        this.rpcProvider.doAction(PageDataActionRequest.create(
                request.getId(),
                request.getPageId(),
                DoActionType.Replenish,
                pageDataRequest.getItems()
        ));

        return this.ok();
    }
}
