package com.bcxin.tenant.bcx.rest.apis.controllers;
import com.bcxin.tenant.bcx.infrastructures.TenantContext;
import com.bcxin.tenant.bcx.rest.apis.controllers.responses.ResponseBuilder;
import com.bcxin.tenant.bcx.rest.apis.utils.ServletRequestUtil;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public abstract class ControllerAbstract {

    @Autowired
    protected HttpServletRequest servletRequest;

    protected <T> ResponseEntity<T> ok(T data) {
        return ResponseBuilder.build(HttpStatus.OK, data);
    }

    protected <T> ResponseEntity<T> ok(T data, String msg) {
        return ResponseBuilder.build(HttpStatus.OK, data, msg, null);
    }

    protected <T> ResponseEntity<T> ok() {
        return ResponseBuilder.build(HttpStatus.OK, null);
    }

    protected ResponseEntity notFound() {
        return ResponseBuilder.build(HttpStatus.NOT_FOUND, null);
    }

    protected ResponseEntity status(HttpStatus status, String msg) {
        return ResponseBuilder.build(status, null, msg, null);
    }

    protected ResponseEntity status(HttpStatus status, Object data, String msg) {
        return ResponseBuilder.build(status, data, msg, null);
    }

    protected ResponseEntity error(String msg) {
        return ResponseBuilder.build(HttpStatus.BAD_REQUEST, null, msg, null);
    }

    protected ResponseEntity badRequest(String msg) {
        return ResponseBuilder.build(HttpStatus.BAD_REQUEST, null);
    }

    protected <T> ResponseEntity<T> badRequest(T data) {
        return ResponseBuilder.build(HttpStatus.BAD_REQUEST, data);
    }

    protected ResponseEntity badRequest(Throwable ex) {
        return ResponseEntity.badRequest().build();
    }

    protected String getSelectedEmployeeId() {
        if (TenantContext.getInstance().getUserContext().get() == null) {
            return null;
        }

        return TenantContext.getInstance().getUserContext().get().getId();
    }


    protected String getCurrentUserId() {
        if (TenantContext.getInstance().getUserContext().get() == null) {
            return null;
        }

        return TenantContext.getInstance().getUserContext().get().getId();
    }

    protected String getCurrentIpAddress() {
        if (servletRequest == null) {
            return null;
        }

        return ServletRequestUtil.getIpAddress(servletRequest);
    }
}
