package com.bcxin.tenant.bcx.rest.apis.controllers;

import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.jdks.CommonDataRpcProvider;
import com.bcxin.tenant.bcx.jdks.requests.commons.CommonDataSearchRequest;
import com.bcxin.tenant.bcx.jdks.responses.commons.CommonSettingResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;
import java.util.Map;

@Tag(name = "CommonDataController", description = "通用数据查询")
@RestController
@RequestMapping("/common-data")
public class CommonDataController extends ControllerAbstract {
    private final CommonDataRpcProvider commonDataRpcProvider;

    public CommonDataController(CommonDataRpcProvider commonDataRpcProvider) {
        this.commonDataRpcProvider = commonDataRpcProvider;
    }

    @PostMapping("/settings/search")
    public ResponseEntity<Collection<CommonSettingResponse>> getSettings() {
        Collection<CommonSettingResponse> data = this.commonDataRpcProvider.getMatchedSettings();

        return this.ok(data);
    }

    @PostMapping("/settings/{code}/query")
    public ResponseEntity<EntityCollection<Map<String,Object>>> search(
            @PathVariable String code,
            @RequestBody CommonDataSearchRequest request) {

        request.setCode(code);
        if (!StringUtils.hasLength(request.getCode())) {
            return this.notFound();
        }

        EntityCollection<Map<String, Object>> data = this.commonDataRpcProvider.search(request);

        return this.ok(data);
    }

    @DeleteMapping("/settings/{code}/caches")
    public void doRemoveSettingCache(@PathVariable String code){
        this.commonDataRpcProvider.removeCache(code);
    }
}
