package com.bcxin.tenant.bcx.rest.apis.configs;

import com.bcxin.tenant.bcx.jdks.AnalyticsLogRpcProvider;
import com.bcxin.tenant.bcx.jdks.CacheWriterProvider;
import com.bcxin.tenant.bcx.jdks.IdentityRpcProvider;
import com.bcxin.tenant.bcx.jdks.QueueRpcProvider;
import org.apache.dubbo.common.constants.ClusterRules;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@ComponentScan(basePackages = "com.bcxin.tenant")
public class WebConfig {
    @DubboReference(methods = {
         //   @Method(name = "")
    })
    private final IdentityRpcProvider identityRpcProvider;

    @DubboReference
    private final QueueRpcProvider queueRpcProvider;

    @DubboReference
    private final AnalyticsLogRpcProvider analyticsLogRpcProvider;

    @DubboReference(cluster = ClusterRules.BROADCAST)
    private final CacheWriterProvider cacheWriterProvider;
    
    public WebConfig(IdentityRpcProvider identityRpcProvider,
                     QueueRpcProvider queueRpcProvider,
                     CacheWriterProvider cacheWriterProvider,
                     AnalyticsLogRpcProvider analyticsLogRpcProvider) {
        this.identityRpcProvider = identityRpcProvider;
        this.queueRpcProvider = queueRpcProvider;
        this.analyticsLogRpcProvider = analyticsLogRpcProvider;
        this.cacheWriterProvider = cacheWriterProvider;
    }


    @Bean
    public FilterRegistrationBean corsFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        final UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        final CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(true); // 允许cookies跨域
        config.addAllowedOriginPattern("*");
        //config.addAllowedOrigin("*");// #允许向该服务器提交请求的URI，*表示全部允许，在SpringMVC中，如果设成*，会自动转成当前请求头中的Origin
        config.addAllowedHeader("*");// #允许访问的头信息,*表示全部
        config.setMaxAge(18000L);// 预检请求的缓存时间（秒），即在这个时间段里，对于相同的跨域请求不会再预检了
        config.addAllowedMethod("*");// 允许提交请求的方法，*表示全部允许
        source.registerCorsConfiguration("/**", config);
        filterRegistrationBean.setFilter(new CorsFilter(source));
        filterRegistrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE);

        return filterRegistrationBean;
    }

    @Bean
    public CloseableHttpClient httpClient(){
        return HttpClientBuilder.create().build();
    }
}