package com.bcxin.tenant.bcx.rest.apis.configs;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
@OpenAPIDefinition(
        info = @Info(
                title = "Swagger3",
                version = "1.0",
                description = "Swagger3使用演示",
                contact = @Contact(name = "TOM")
        ),
        security = @SecurityRequirement(name = "JWT"),
        externalDocs = @ExternalDocumentation(description = "参考文档",
                url = "https://github.com/swagger-api/swagger-core/wiki/Swagger-2.X---Annotations"
        )
)
@SecurityScheme(type = SecuritySchemeType.HTTP, name = "JWT", scheme = "bearer", in = SecuritySchemeIn.HEADER)
 */
@Configuration
public class Swagger3Config {
        /**
         * https://blog.csdn.net/renpeng301/article/details/124660893
         * https://springdoc.org/v2
         *
         * @return
         */
        @Bean
        public OpenAPI restfulOpenAPI() {
                Components components = new Components()
                        .addParameters("accessToken",new Parameter().name("accessToken").description("V5的Token信息"));
                return new OpenAPI()
                        .info(new Info().title("百川信调度指挥API文档 1.0")
                                .description("百川信调度指挥开发API详细文档")
                                .version("v1.0.0")
                                .license(new License().name("百川信-调度指挥")
                                        .url("https://v5qy.baibaodun.cn/static/signon/")))
                        .components(components)
                        .externalDocs(new ExternalDocumentation()
                                .description("百川信调度指挥开发API详细文档")
                                .url("https://v5qy.baibaodun.cn/dispatch/swagger-ui/index.html"));
        }
}
