package com.bcxin.tenant.bcx.rest.apis.configs;
import com.bcxin.tenant.bcx.dubbo.common.configs.DubboConfigProperty;
import com.bcxin.tenant.bcx.infrastructures.components.DefaultIdWorkerImpl;
import com.bcxin.tenant.bcx.infrastructures.components.IdWorker;
import com.bcxin.tenant.bcx.jdks.*;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableDubbo(scanBasePackages = "com.bcxin.tenant.bcx.rest.apis.impls")
public class DubboConfig {

    @DubboReference
    private final CommonDataRpcProvider commonDataRpcProvider;

    @DubboReference
    private final MenuMetaRpcProvider menuMetaRpcProvider;

    @DubboReference
    private final ProjectMetaRpcProvider projectMetaRpcProvider;

    @DubboReference
    private final PageMetaRpcProvider pageMetaRpcProvider;

    @DubboReference
    private final ModuleMetaRpcProvider moduleMetaRpcProvider;

    @DubboReference
    private final PageMetaSettingRpcProvider pageMetaSettingRpcProvider;

    @DubboReference
    private final OrganRegistryFormsRpcProvider organRegistryFormsRpcProvider;
    @DubboReference
    private final PageDataRpcProvider pageDataRpcProvider;

    @DubboReference
    private final ExamEnrollmentCriteriaRpcProvider examEnrollmentCriteriaRpcProvider;

    @DubboReference
    private final ExamSubjectRpcProvider examSubjectRpcProvider;

    public DubboConfig(CommonDataRpcProvider commonDataRpcProvider, MenuMetaRpcProvider menuMetaRpcProvider,
                       ProjectMetaRpcProvider projectMetaRpcProvider, PageMetaRpcProvider pageMetaRpcProvider,
                       ModuleMetaRpcProvider moduleMetaRpcProvider,
                       PageMetaSettingRpcProvider pageMetaSettingRpcProvider,
                       OrganRegistryFormsRpcProvider organRegistryFormsRpcProvider,
                       PageDataRpcProvider pageDataRpcProvider,
                       ExamEnrollmentCriteriaRpcProvider examEnrollmentCriteriaRpcProvider,
                       ExamSubjectRpcProvider examSubjectRpcProvider) {
        this.commonDataRpcProvider = commonDataRpcProvider;
        this.menuMetaRpcProvider = menuMetaRpcProvider;
        this.projectMetaRpcProvider = projectMetaRpcProvider;
        this.pageMetaRpcProvider = pageMetaRpcProvider;
        this.moduleMetaRpcProvider = moduleMetaRpcProvider;
        this.pageMetaSettingRpcProvider = pageMetaSettingRpcProvider;
        this.organRegistryFormsRpcProvider = organRegistryFormsRpcProvider;
        this.pageDataRpcProvider = pageDataRpcProvider;
        this.examEnrollmentCriteriaRpcProvider = examEnrollmentCriteriaRpcProvider;
        this.examSubjectRpcProvider = examSubjectRpcProvider;
    }

    @Bean
    public ConsumerConfig registryConfig(DubboConfigProperty property) {
        ConsumerConfig config = new ConsumerConfig();
        config.setCheck(false);
        /**
         * 不过期
         */
        config.setTimeout(120 * 1000);
        /**
         * 禁用重试
         */
        config.setRetries(0);
        config.setVersion(property.getVersion());

        return config;
    }

    @Bean
    public IdWorker idWorker() {
        return new DefaultIdWorkerImpl();
    }
}
