package com.bcxin.tenant.bcx.rest.apis.components;

import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

@Getter
public class ValidationErrorResponse {
    private final List<Violation> violations = new ArrayList<>();
    private final String message;

    public ValidationErrorResponse(String message) {
        this.message = message;
    }

    public static ValidationErrorResponse create(String message) {
        return new ValidationErrorResponse(message);
    }

    public ValidationErrorResponse addFieldMessage(String fieldName, String message,Object rejectedValue) {
        this.violations.add(Violation.create(fieldName, message,rejectedValue));

        return this;
    }

    public ValidationErrorResponse addFieldMessage(String fieldName, String message) {
        this.violations.add(Violation.create(fieldName, message, null));

        return this;
    }

    @Getter
    public static class Violation {
        private final String fieldName;
        private final String message;
        private final Object rejectedValue;

        public Violation(String fieldName, String message,Object rejectedValue) {
            this.fieldName = fieldName;
            this.message = message;
            this.rejectedValue = rejectedValue;
        }

        public static Violation create(String fieldName, String message,Object rejectedValue) {
            return new Violation(fieldName, message,rejectedValue);
        }
    }
}
