package com.bcxin.tenant.bcx.rest.apis.components;

import com.bcxin.tenant.bcx.infrastructures.components.ExcelProvider;
import com.bcxin.tenant.bcx.infrastructures.exceptions.BadTenantException;
import org.springframework.stereotype.Component;

import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@Component
public class ExtractDataComponent {
    private final WebFileProvider webFileProvider;
    private final ExcelProvider excelProvider;

    public ExtractDataComponent(WebFileProvider webFileProvider, ExcelProvider excelProvider) {
        this.webFileProvider = webFileProvider;
        this.excelProvider = excelProvider;
    }

    public <T> Collection<T> extract(int headRow, String path, Function<Collection<Map<Integer,String>>, Collection<T>> function) {
        String downloadUrl = path;//URLDecoder.decode(path);//path;//URLUtil.decode(path);
        try(InputStream reader = this.webFileProvider.download(downloadUrl)){
            return extract(reader, function);
        }
        catch (Exception ex){
            throw new BadTenantException("文件读取异常", ex);
        }
    }

    public <T> Collection<T> extract(int headRow, InputStream inputStream, Function<Collection<Map<Integer,String>>, Collection<T>> function) {
        try (InputStream reader = inputStream) {
            return extract(reader, function);
        } catch (Exception ex) {
            throw new BadTenantException("文件读取异常", ex);
        }
    }

    private <T> Collection<T> extract(InputStream reader, Function<Collection<Map<Integer,String>>, Collection<T>> function)
    {
        Map<String, Object> attributes = new HashMap<>();
        attributes.put(ExcelProvider.ATTRIBUTE_HEADER_ROW_COUNT, 1);
        Collection<Map<Integer, String>> excelMapValues = this.excelProvider.read(reader, attributes);
        return function.apply(excelMapValues);
    }
}
