/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.jdks.responses.pages;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.PageBusinessType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Map;

@Schema(name="PageDataResponse", title="\u52a8\u6001\u9875\u9762\u6570\u636e")
public class PageDataResponse
extends ResponseAbstract {
    @Schema(name="id", title="id")
    private final String id;
    @ExcelIgnore
    @Schema(name="pageId", title="\u9875\u9762Id")
    private final String pageId;
    @ExcelIgnore
    @Schema(name="businessType", title="\u4e1a\u52a1\u7c7b\u578b")
    private final PageBusinessType businessType;
    @ExcelIgnore
    private final Map<String, Object> items;
    @ColumnWidth(value=50)
    @ExcelProperty(value={"\u521b\u5efa\u65f6\u95f4"})
    private final String createdTime;
    @ColumnWidth(value=50)
    @ExcelProperty(value={"\u6700\u540e\u4fee\u6539\u65f6\u95f4"})
    private final String lastUpdatedTime;

    public String getBusinessTypeLabel() {
        return this.businessType.getName();
    }

    public PageDataResponse(String id, String pageId, PageBusinessType businessType, Map<String, Object> items, Timestamp createdTime, Timestamp lastUpdatedTime) {
        this.id = id;
        this.pageId = pageId;
        this.businessType = businessType;
        this.items = items;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.createdTime = createdTime == null ? "-" : dateFormat.format(createdTime);
        this.lastUpdatedTime = lastUpdatedTime == null ? "-" : dateFormat.format(lastUpdatedTime);
    }

    public static PageDataResponse create(String id, String pageId, PageBusinessType businessType, Map<String, Object> items, Timestamp createdTime, Timestamp lastUpdatedTime) {
        return new PageDataResponse(id, pageId, businessType, items, createdTime, lastUpdatedTime);
    }

    public String getId() {
        return this.id;
    }

    public String getPageId() {
        return this.pageId;
    }

    public PageBusinessType getBusinessType() {
        return this.businessType;
    }

    public Map<String, Object> getItems() {
        return this.items;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public String getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }
}

