package com.bcxin.backend.domain.system.services.impls;

import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.backend.domain.system.dispatch.requests.DispatchRequestAbstract;
import com.bcxin.backend.domain.system.dispatch.requests.DispatchType;
import com.bcxin.backend.domain.system.dispatch.requests.UserDispatchRequest;
import com.bcxin.backend.domain.system.dispatch.snapshots.UserValueSnapshot;
import com.bcxin.backend.domain.system.entities.UserDTO;
import com.bcxin.backend.domain.system.repositories.UserRepository;
import com.bcxin.backend.domain.system.configs.DispatchSiteResourceProperties;
import com.bcxin.backend.domain.system.dispatch.DataDispatcher;
import com.bcxin.backend.domain.system.dispatch.DispatchTranslateUtil;
import com.bcxin.backend.domain.system.services.UserService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;

@Service
public class UserServiceImpl implements UserService {
    private final UserRepository userRepository;
    private final DataDispatcher dataDispatcher;
    private final DispatchSiteResourceProperties resourceProperties;

    public UserServiceImpl(UserRepository userRepository, DataDispatcher dataDispatcher,
                           DispatchSiteResourceProperties resourceProperties) {
        this.userRepository = userRepository;
        this.dataDispatcher = dataDispatcher;
        this.resourceProperties = resourceProperties;
    }

    @Override
    public void dispatch2DataExchange() {
        /*
        Collection<UserDTO> userDTOS = null;
        do {
            Page<UserDTO> userDTOPage = null;
            try {
                userDTOPage = userRepository.getPendingSyncs(PageRequest.of(0, 200));
                userDTOS = userDTOPage.getContent();
                userDTOS.forEach(user -> {
                    try {
                        UserValueSnapshot userValueSnapshot = DispatchTranslateUtil.translate(user, resourceProperties);
                        this.dataDispatcher.dispatch(UserDispatchRequest.create(DispatchType.Created, userValueSnapshot));

                        user.doneForDataExchange();
                    } catch (Exception ex) {
                        user.markDispatchError(ExceptionUtils.getStackMessage(ex));
                    }

                    this.userRepository.save(user);
                });
            } finally {
                // this.userRepository.saveAll(dispatchedUsers);
            }
        } while (userDTOS != null && userDTOS.size() > 0);
         */
    }
}
