package com.bcxin.backend.domain.syncs.components.dtos;

import lombok.Data;

import java.util.Collection;
import java.util.Date;
import java.util.Map;

@Data
public class DataSet {
    private String tableName;
    private String sql;
    private Date fetchedModifiedTime;
    private Date exportedTime;
    private int totalCount;
    private Collection<Column> columns;
    private Collection<Map<String, Object>> rows;

    public DataSet() {
    }

    public static DataSet create(
            String tableName, int totalCount, Collection<Column> columns,
            Collection<Map<String, Object>> rows) {
        DataSet record = new DataSet();
        record.setTableName(tableName);
        record.setTotalCount(totalCount);
        record.setColumns(columns);
        record.setRows(rows);

        return record;
    }

    public void markInfo(String sql, Date fetchedModifiedTime, Date exportedTime) {
        this.setSql(sql);
        this.setExportedTime(exportedTime);
        this.setFetchedModifiedTime(fetchedModifiedTime);
    }

    @Data
    public static class Column {
        private boolean isFile;
        private String name;

        public static Column create(String name) {
            Column column = new Column();
            //String attachValue = itemJSONObject.getString("AttachmentUploadField");
            //String imageUploadValue = itemJSONObject.getString("imageUploadValue");

            if ("AttachmentUploadField".equalsIgnoreCase(name) || "imageUploadValue".equals(name)) {
                column.setFile(true);
            }

            column.setName(name);

            return column;
        }
    }
}
