package com.bcxin.backend.domain.auth.factory;

import com.bcxin.backend.core.exceptions.SaasBadException;
import com.bcxin.backend.domain.auth.service.AuthenticationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * <b> 实名认证工厂 </b>
 * @author ZXF
 * @create 2022/09/22 0022 14:53
 * @version
 * @注意事项 </b>
 */
@Service
public class AuthFactory {

    public Map<String, AuthenticationService> connectionMap;
    private final String serverKey;

    public AuthFactory(Map<String, AuthenticationService> connectionMap,
                       @Value("${myapps.authentication.serverKey}")String serverKey) {
        this.connectionMap = connectionMap;
        this.serverKey = serverKey;
    }

    public AuthenticationService getAuthByType(){
        String type = StringUtils.isEmpty(serverKey)?"auth_common":serverKey;
        AuthenticationService service = this.connectionMap.get(type);
        if(service == null){
            throw new SaasBadException(String.format("RealNameAuthenticationType:%s dose not support", type));
        }
        return service;
    }
}
