package com.bcxin.backend.domain.repositories;

import com.bcxin.backend.domain.models.SignatureCheckDocument;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

public interface SignatureCheckDocumentRepository extends JpaRepository<SignatureCheckDocument,Long> {
    @Query("select s from SignatureCheckDocument s where s.status=?1 order by s.created desc")
    Page<SignatureCheckDocument> pageQueues(int status, PageRequest pageRequest);

    @Modifying
    @Transactional
    @Query("UPDATE SignatureCheckDocument s SET s.status=?1,s.processed_result=?2 WHERE s.id=?3")
    void updateStatus(int status, String result, Long id);
}
