package com.bcxin.flink.core;

import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.JobType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.flinks.JdbcParameterDTO;
import com.bcxin.tenant.open.infrastructures.flinks.JdbcSqlTemplateDefinition;
import com.bcxin.tenant.open.infrastructures.flinks.JobParameterDTO;

import java.sql.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class JdbcJobExecutorUtil {
    public static JobParameterDTO getJobParameter(int jobId) {
        try {
            JsonProvider jsonProvider = new JsonProvider.DefaultJsonProvider();
            try (Connection connection = getConnection()) {
                try (PreparedStatement statement = connection.prepareStatement("select * from flink_jobs where id=? and is_online=1")) {
                    statement.setInt(1, jobId);

                    try (ResultSet resultSet = statement.executeQuery()) {
                        while (resultSet.next()) {
                            String name = resultSet.getString("name");
                            int type = (Integer) resultSet.getObject("job_type");
                            JobType job_type = Arrays.stream(JobType.values()).filter(ix -> ix.ordinal() == type).findFirst().get();
                            String parameter_json = resultSet.getString("parameter_json");
                            String description = resultSet.getString("description");

                            JobParameterDTO parameterDTO = JobParameterDTO.create(name, job_type, parameter_json, description);

                            String param2 = parameterDTO.getParam2(jsonProvider);
                            JdbcSqlTemplateDefinition jdbcSqlTemplateDefinition = jsonProvider.toObject(JdbcSqlTemplateDefinition.class, param2);
                            if (jdbcSqlTemplateDefinition != null && jdbcSqlTemplateDefinition.getJdbcId() == null) {

                            }

                            return parameterDTO;
                        }

                        return null;
                    }
                }
            }
        } catch (Exception ex) {
            throw new BadTenantException("", ex);
        }
    }

    public static Collection<JdbcParameterDTO> getJdbcParameterDTO(List<Long> jdbcIds) {
        try {
            try (Connection connection = getConnection()) {
                StringBuilder inWhere = new StringBuilder("id in (");
                for(int index=0;index<jdbcIds.size();index++) {
                    inWhere.append("?");
                    if (index != jdbcIds.size() - 1) {
                        inWhere.append(",");
                    }
                }
                inWhere.append(")");

                String sql = String.format("select id,`name`,drive_class_name,url,user_name,password,server_time_zone from flink_jdbc_definitions where %s",inWhere);

                try (PreparedStatement statement = connection.prepareStatement(sql)) {
                    for(int index=0;index<jdbcIds.size();index++) {
                        statement.setObject(index + 1, jdbcIds.get(index));
                    }

                    Collection<JdbcParameterDTO> jdbcParameterDTOS = new ArrayList<>();

                    try (ResultSet resultSet = statement.executeQuery()) {
                        while (resultSet.next()) {
                            Long id = resultSet.getLong("id");
                            String name = resultSet.getString("name");
                            String driveClassName = resultSet.getString("drive_class_name");
                            String url = resultSet.getString("url");
                            String user_name = resultSet.getString("user_name");
                            String password = resultSet.getString("password");
                            String serverTimeZone = resultSet.getString("server_time_zone");

                            JdbcParameterDTO parameterDTO = JdbcParameterDTO.create(id, name, url, user_name, password, serverTimeZone, driveClassName);
                            jdbcParameterDTOS.add(parameterDTO);
                        }

                        return jdbcParameterDTOS;
                    }
                }
            }
        } catch (Exception ex) {
            throw new BadTenantException("", ex);
        }
    }

    private static Connection getConnection() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String driverClassName =
                System.getProperties().getProperty("datasource.driver-class-name");
        String url =
                System.getProperties().getProperty("datasource.url");
        String userName =
                System.getProperties().getProperty("datasource.username");
        String password =
                System.getProperties().getProperty("datasource.password");

        Class driverClass =
                JdbcJobExecutorUtil.class.getClassLoader().loadClass(driverClassName);
        Driver driver = (Driver) driverClass.newInstance();
        DriverManager.registerDriver(driver);

        return DriverManager.getConnection(url, userName, password);
    }
}
