package com.bcxin.flink.core;

import com.bcxin.flink.core.properties.CheckpointConfigProperty;
import com.bcxin.flink.core.properties.CheckpointConfigPropertyBuilder;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.JobType;
import com.bcxin.tenant.open.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.open.infrastructures.flinks.JobParameterDTO;
import com.bcxin.tenant.open.infrastructures.utils.PropertyUtils;

import java.io.IOException;
import java.util.Properties;

public abstract class AppAbstract {
    private static final String DATABASE_PROPERTY_CONF="databasePropertyConf";
    protected static void initEnv(String[] args) throws IOException {
        String env = args[0];
        SystemPropertyUtil.loadEnvConf(env);
    }

    /**
     * 初始化参数配置
     * @param jobId
     * @throws IOException
     */
    protected static CheckpointConfigProperty initCheckPointAndEnv(JsonProvider jsonProvider, String jobId) throws IOException {
        JobParameterDTO jobParameterDTO = getJobParameter(jobId);
        if (jobParameterDTO == null) {
            throw new NoFoundTenantException("参数无效; 无法加载对应的job参数");
        }
        if (jobParameterDTO.getJobType() != JobType.WEBHOOK_API) {
            throw new IllegalArgumentException(String.format("该jobType(%s)不支持流处理", jobParameterDTO.getJobType()));
        }

        String corePropertyConf = jobParameterDTO.getParam1(jsonProvider);
        String databasePropertyConf = jobParameterDTO.getParam2(jsonProvider);
        Properties properties = PropertyUtils.loadProperties(jsonProvider, corePropertyConf);
        properties.setProperty(DATABASE_PROPERTY_CONF,databasePropertyConf);

        CheckpointConfigProperty configProperty =
                CheckpointConfigPropertyBuilder.build(properties);

        return configProperty;
    }

    protected static JobParameterDTO getJobParameter(String jobId) {
        JobParameterDTO jobParameterDTO = JdbcJobExecutorUtil.getJobParameter(Integer.parseInt(jobId));
        if (jobParameterDTO == null) {
            throw new NoFoundTenantException(String.format("找不到该配置项:%s", jobId));
        }

        return jobParameterDTO;
    }

    protected static String getDatabasePropertyConfAfterInitEnv() {
        return System.getProperty(DATABASE_PROPERTY_CONF);
    }
}
