/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument$;
import com.bcxin.tenant.open.domains.dtos.PoliceIncidentsSosUpdateDTO;
import com.bcxin.tenant.open.domains.entities.PoliceIncidentsEntity;
import com.bcxin.tenant.open.domains.entities.valueTypes.GeoPointValueType;
import com.bcxin.tenant.open.domains.repositories.PoliceIncidentsRepository;
import com.bcxin.tenant.open.domains.services.PoliceIncidentsService;
import com.bcxin.tenant.open.domains.services.commands.CreatePoliceIncidentsCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateSsoPoliceIncidentsCommand;
import com.bcxin.tenant.open.domains.services.commands.UpdatePoliceIncidentStatusCommand;
import com.bcxin.tenant.open.domains.services.commands.UpdatePoliceIncidentsCommand;
import com.bcxin.tenant.open.domains.services.commands.UpdateSosPoliceIncidentStatusCommand;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventStatus;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.predicates.SearchFieldPredicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PoliceIncidentsServiceImpl
implements PoliceIncidentsService {
    private final JsonProvider jsonProvider;
    private final UnitWork unitWork;
    private final PoliceIncidentsRepository policeIncidentsRepository;
    private final EntityStream entityStream;
    private final IdWorker idWorker;

    public PoliceIncidentsServiceImpl(JsonProvider jsonProvider, UnitWork unitWork, PoliceIncidentsRepository policeIncidentsRepository, EntityStream entityStream, IdWorker idWorker) {
        this.jsonProvider = jsonProvider;
        this.unitWork = unitWork;
        this.policeIncidentsRepository = policeIncidentsRepository;
        this.entityStream = entityStream;
        this.idWorker = idWorker;
    }

    @Override
    public void dispatch(CreatePoliceIncidentsCommand command) {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        if (BusinessUtil.checkIfDesk((DispatchAccountType)userModel.getAccountType())) {
            throw new BadTenantException("\u8c03\u5ea6\u53f0\u8d26\u53f7, \u4e0d\u5141\u8bb8\u8fdb\u884c\u8b66\u60c5\u4e0a\u62a5");
        }
        String securityStationId = "#1";
        String securityStationName = "#1";
        String securityStationAddress = null;
        String superviseDepartId = userModel.getSuperviseDepartId();
        String projectId = "#1";
        String projectName = "";
        Set<Object> resourceTypes = new HashSet<ResourceType>();
        resourceTypes.add(ResourceType.Security);
        if (BusinessUtil.checkIfSecurityStationRelativeUsers((String)userModel.getOrgInstitutional())) {
            RdSecurityStationDocument securityStationDocument;
            securityStationId = userModel.getSecurityStationId();
            boolean hasSecurityStation = false;
            if (StringUtils.hasLength((String)securityStationId) && !"#1".equalsIgnoreCase(securityStationId) && (securityStationDocument = (RdSecurityStationDocument)this.entityStream.of(RdSecurityStationDocument.class).filter((SearchFieldPredicate)RdSecurityStationDocument$.ID.eq((Object)securityStationId)).findFirst().orElse(null)) != null) {
                hasSecurityStation = true;
                securityStationName = securityStationDocument.getName();
                securityStationAddress = securityStationDocument.getAddress();
                projectName = securityStationDocument.getProjectName();
                projectId = securityStationDocument.getProjectId();
                resourceTypes.clear();
                resourceTypes = ResourceType.toResourceTypes((Set)securityStationDocument.getResourceTypes());
            }
            if (!StringUtils.hasLength((String)projectId)) {
                projectId = "#1";
            }
            if (!hasSecurityStation) {
                throw new BadTenantException("\u672a\u5b89\u6392\u9a7b\u52e4\u70b9\u7684\u4fdd\u5b89\u4eba\u5458, \u4e0d\u5141\u8bb8\u8fdb\u884c\u8b66\u60c5\u4e0a\u62a5");
            }
        }
        if (!StringUtils.hasLength((String)superviseDepartId)) {
            superviseDepartId = "#1";
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            int calculatedResourceType;
            PoliceIncidentsEntity policeIncident = new PoliceIncidentsEntity();
            String code = String.valueOf(this.idWorker.getNextId());
            policeIncident.setCode(code);
            policeIncident.setAddress(command.getAddress());
            policeIncident.setContact(command.getContact());
            policeIncident.setEmpName(userModel.getName());
            policeIncident.setLonLat(GeoPointValueType.create(command.getLatitude(), command.getLongitude()));
            policeIncident.setName(command.getName());
            policeIncident.setSecurityStationId(securityStationId);
            policeIncident.setSecurityStationName(securityStationName);
            policeIncident.setSecurityStationAddress(securityStationAddress);
            policeIncident.setSuperviseDepartId(superviseDepartId);
            policeIncident.setTenantEmployeeId(userModel.getEmployeeId());
            policeIncident.setTenantUserId(userModel.getTencentUserId());
            policeIncident.setCategory(command.getCategory());
            policeIncident.setLocation(command.getLocation());
            policeIncident.setPoliceEventStatus(PoliceEventStatus.None);
            policeIncident.setPoliceEventLevel(command.getPoliceEventLevel());
            policeIncident.setPoliceEventType(command.getPoliceEventType());
            policeIncident.setOrganizationId(userModel.getOrganizationId());
            policeIncident.setOrganizationName(userModel.getOrgName());
            policeIncident.setReason(command.getReason());
            policeIncident.setSceneUrl(command.getSceneUrl());
            policeIncident.setActionTaken(command.getActionTaken());
            policeIncident.setActionTendency(command.getActionTendency());
            policeIncident.setDescription(command.getDescription());
            if ("#1".equalsIgnoreCase(policeIncident.getSuperviseDepartName())) {
                policeIncident.setSuperviseDepartName(" ");
            }
            if ("#1".equalsIgnoreCase(policeIncident.getSecurityStationName())) {
                policeIncident.setSecurityStationName(" ");
            }
            if ((calculatedResourceType = ResourceType.getCalculatedResourceValue(resourceTypes)) < 1) {
                calculatedResourceType = 1;
            }
            policeIncident.setCalculatedResourceType(calculatedResourceType);
            policeIncident.setProjectId(projectId);
            policeIncident.setProjectName(projectName);
            this.policeIncidentsRepository.insert(policeIncident);
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    @Override
    public void dispatch(UpdatePoliceIncidentsCommand command) {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        PoliceIncidentsEntity policeIncident = this.policeIncidentsRepository.getById(command.getId());
        if (policeIncident == null) {
            throw new NoFoundTenantException();
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            policeIncident.process(userModel.getEmployeeId(), userModel.getName(), command.getPoliceEventStatus(), command.getActionTaken(), command.getActionTendency(), command.getProcessedSuggestion(), command.getProcessedLocaleGuidance());
            this.policeIncidentsRepository.update(policeIncident);
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    @Override
    public void dispatch(UpdatePoliceIncidentStatusCommand command) {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        PoliceIncidentsEntity policeIncident = this.policeIncidentsRepository.getById(command.getId());
        if (policeIncident == null) {
            throw new NoFoundTenantException();
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            policeIncident.makeAsOverStatus(userModel.getEmployeeId(), userModel.getName(), command.getStatus());
            this.policeIncidentsRepository.update(policeIncident);
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    @Override
    public void dispatch(Collection<CreateSsoPoliceIncidentsCommand> commands) {
        this.unitWork.executeTran(() -> commands.forEach(command -> {
            String code = String.valueOf(this.idWorker.getNextId());
            PoliceIncidentsEntity entity = PoliceIncidentsEntity.createSos(this.jsonProvider, code, command.getTenantUserId(), command.getTenantEmployeeId(), command.getOrganizationId(), command.getOrganizationName(), command.getSecurityStationId(), command.getSecurityStationName(), command.getProjectId(), command.getProjectName(), command.getStationAddress(), command.getSuperviseDepartId(), command.getSuperviseDepartName(), command.getTenantUserIdCard(), command.getTenantUserName(), command.getLatitude(), command.getLongitude(), command.getAddress(), command.getResourceTypes());
            this.policeIncidentsRepository.insert(entity);
        }));
    }

    @Override
    public void dispatch(UpdateSosPoliceIncidentStatusCommand command) {
        this.unitWork.executeTran(() -> this.policeIncidentsRepository.updateSsoStatus(PoliceIncidentsSosUpdateDTO.create(command.getId(), command.getProcessorId(), command.getProcessedUserName())));
    }
}

