/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.exceptions.ArgumentTenantException;
import java.util.Collection;
import org.springframework.util.StringUtils;

public class CreateRollCallCommand
extends CommandAbstract {
    private final Long rollCallPlanId;
    private final String timeValue;
    private final Collection<String> superviseDepartIds;
    private final Collection<String> securityStationIds;
    private final Collection<String> stationTypes;
    private final DoActionOperatorCommandItem operator;

    public CreateRollCallCommand(Long rollCallPlanId, String timeValue, Collection<String> superviseDepartIds, Collection<String> securityStationIds, Collection<String> stationTypes, DoActionOperatorCommandItem operator) {
        this.rollCallPlanId = rollCallPlanId;
        this.timeValue = timeValue;
        this.superviseDepartIds = superviseDepartIds;
        this.securityStationIds = securityStationIds;
        this.stationTypes = stationTypes;
        this.operator = operator;
    }

    public static CreateRollCallCommand create(Long rollCallPlanId, String timeValue, Collection<String> superviseDepartIds, Collection<String> securityStationIds, Collection<String> stationTypes, DoActionOperatorCommandItem operator) {
        return new CreateRollCallCommand(rollCallPlanId, timeValue, superviseDepartIds, securityStationIds, stationTypes, operator);
    }

    public Long getRollCallPlanId() {
        return this.rollCallPlanId;
    }

    public String getTimeValue() {
        return this.timeValue;
    }

    public Collection<String> getSuperviseDepartIds() {
        return this.superviseDepartIds;
    }

    public Collection<String> getSecurityStationIds() {
        return this.securityStationIds;
    }

    public Collection<String> getStationTypes() {
        return this.stationTypes;
    }

    public DoActionOperatorCommandItem getOperator() {
        return this.operator;
    }

    public static class DoActionOperatorCommandItem
    extends CommandAbstract {
        private final String actionOrgInstitutional;
        private final String actionOrganizationId;
        private final String actionOrganizationName;
        private final String actionEmployeeId;
        private final String actionEmployeeName;

        public DoActionOperatorCommandItem(String actionOrganizationId, String actionOrgInstitutional, String actionOrganizationName, String actionEmployeeId, String actionEmployeeName) {
            this.actionOrganizationId = actionOrganizationId;
            this.actionOrganizationName = actionOrganizationName;
            this.actionEmployeeId = actionEmployeeId;
            this.actionEmployeeName = actionEmployeeName;
            this.actionOrgInstitutional = actionOrgInstitutional;
        }

        public static DoActionOperatorCommandItem create(String actionOrganizationId, String actionOrgInstitutional, String actionOrganizationName, String actionEmployeeId, String actionEmployeeName) {
            return new DoActionOperatorCommandItem(actionOrganizationId, actionOrgInstitutional, actionOrganizationName, actionEmployeeId, actionEmployeeName);
        }

        public void validate() {
            if (!StringUtils.hasLength((String)this.getActionOrganizationId())) {
                throw new ArgumentTenantException("\u64cd\u4f5c\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasLength((String)this.getActionEmployeeId())) {
                throw new ArgumentTenantException("\u64cd\u4f5c\u4eba\u4e3a\u7a7a");
            }
        }

        public String getActionOrgInstitutional() {
            return this.actionOrgInstitutional;
        }

        public String getActionOrganizationId() {
            return this.actionOrganizationId;
        }

        public String getActionOrganizationName() {
            return this.actionOrganizationName;
        }

        public String getActionEmployeeId() {
            return this.actionEmployeeId;
        }

        public String getActionEmployeeName() {
            return this.actionEmployeeName;
        }
    }
}

