/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.eventListeners;

import com.bcxin.tenant.open.domains.entities.DeviceCommunicatedLogDetailEntity;
import com.bcxin.tenant.open.domains.events.PreparedRoomCommunicatedGroupEvent;
import com.bcxin.tenant.open.domains.repositories.ConfigOfBillRepository;
import com.bcxin.tenant.open.domains.services.DeviceCommunicatedLogService;
import com.bcxin.tenant.open.domains.services.commands.CreateDeviceCommunicatedLogCommand;
import com.bcxin.tenant.open.domains.utils.DeviceCommunicatedLogDetailUtils;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PreparedRoomCommunicatedGroupListener_DeviceCommunicatedLogDetail
implements ApplicationListener<PreparedRoomCommunicatedGroupEvent> {
    private final DeviceCommunicatedLogService deviceCommunicatedLogService;
    private final IdWorker idWorker;
    private final ConfigOfBillRepository configOfBillRepository;

    public PreparedRoomCommunicatedGroupListener_DeviceCommunicatedLogDetail(DeviceCommunicatedLogService deviceCommunicatedLogService, IdWorker idWorker, ConfigOfBillRepository configOfBillRepository) {
        this.deviceCommunicatedLogService = deviceCommunicatedLogService;
        this.idWorker = idWorker;
        this.configOfBillRepository = configOfBillRepository;
    }

    public void onApplicationEvent(PreparedRoomCommunicatedGroupEvent event) {
        Collection<DeviceCommunicatedLogDetailEntity> logDetails = DeviceCommunicatedLogDetailUtils.build(this.configOfBillRepository.get(), this.idWorker, event.getRoomCommunicatedGroups());
        if (CollectionUtils.isEmpty(logDetails)) {
            String roomId = event.getRoomCommunicatedGroups().stream().map(ix -> ix.getRoomId()).distinct().collect(Collectors.joining(";"));
            throw new BadTenantException(String.format("\u65e0\u751f\u6210\u6709\u6548\u8c03\u5ea6\u8bb0\u5f55(%s), \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", roomId));
        }
        this.deviceCommunicatedLogService.dispatch(CreateDeviceCommunicatedLogCommand.create(logDetails));
    }
}

