/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RepetitiveRule;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;

@TableName(value="vga_roll_call_plans", autoResultMap=true)
public class RollCallPlanEntity
extends EntityAbstract
implements Aggregate {
    @TableId(value="id")
    private Long id;
    @TableField(value="name")
    private String name;
    @TableField(value="begin_date")
    private Date beginDate;
    @TableField(value="end_date")
    private Date endDate;
    @TableField(value="repetitive_rule")
    private int repetitiveRule;
    @TableField(value="supervise_depart_id")
    private String superviseDepartId;
    @TableField(value="supervise_depart_name")
    private String superviseDepartName;
    @TableField(value="station_types")
    private String stationTypes;
    @TableField(value="periods_of_times")
    private String periodsOfTimes;
    @TableField(value="created_time")
    private Timestamp createdTime;
    @TableField(value="organization_id")
    private String organizationId;
    @TableField(value="organization_institutional")
    private String organizationInstitutional;
    @TableField(value="organization_name")
    private String organizationName;
    @TableField(value="creator_id")
    private String creatorId;
    @TableField(value="creator_name")
    private String creatorName;
    @TableField(value="last_updated_time")
    private Timestamp lastUpdatedTime;
    @TableField(value="last_updater_id")
    private String lastUpdaterId;
    @TableField(value="last_updater_name")
    private String lastUpdaterName;
    @TableField(value="deleted")
    private boolean deleted;
    @TableField(value="deleted_time")
    private Timestamp deletedTime;
    @TableField(value="count_of_instances")
    private int countOfInstances;

    public RollCallPlanEntity() {
        this.createdTime = Timestamp.from(Instant.now());
        this.deleted = false;
        this.countOfInstances = 0;
    }

    public void delete() {
        this.setDeleted(true);
        this.setDeletedTime(Timestamp.from(Instant.now()));
    }

    public void change(String name, Date beginDate, Date endDate, Collection<RepetitiveRule> repetitiveRules, String superviseDepartId, String superviseDepartName, String stationTypes, String periodsOfTimes, String lastUpdaterId, String lastUpdaterName) {
        this.setName(name);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setRepetitiveRule(RepetitiveRule.calculateRepetitiveRule(repetitiveRules));
        this.setSuperviseDepartId(superviseDepartId);
        this.setSuperviseDepartName(superviseDepartName);
        this.setStationTypes(stationTypes);
        this.setPeriodsOfTimes(periodsOfTimes);
        this.setLastUpdaterId(lastUpdaterId);
        this.setLastUpdaterName(lastUpdaterName);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void markDeleted() {
        this.setDeletedTime(Timestamp.from(Instant.now()));
        this.setDeleted(true);
    }

    public RollCallPlanEntity(Long id, String name, Date beginDate, Date endDate, Collection<RepetitiveRule> repetitiveRules, String superviseDepartId, String superviseDepartName, String stationTypes, String periodsOfTimes, String organizationId, String organizationInstitutional, String organizationName, String creatorId, String creatorName) {
        this.id = id;
        this.name = name;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.repetitiveRule = RepetitiveRule.calculateRepetitiveRule(repetitiveRules);
        this.superviseDepartId = superviseDepartId;
        this.superviseDepartName = superviseDepartName;
        this.stationTypes = stationTypes;
        this.periodsOfTimes = periodsOfTimes;
        this.creatorId = creatorId;
        this.creatorName = creatorName;
        this.lastUpdatedTime = null;
        this.lastUpdaterId = null;
        this.lastUpdaterName = null;
        this.organizationId = organizationId;
        this.organizationInstitutional = organizationInstitutional;
        this.organizationName = organizationName;
        this.createdTime = Timestamp.from(Instant.now());
    }

    public static RollCallPlanEntity create(Long id, String name, Date beginDate, Date endDate, Collection<RepetitiveRule> repetitiveRules, String superviseDepartId, String superviseDepartName, String stationTypes, String periodsOfTimes, String organizationId, String organizationInstitutional, String organizationName, String creatorId, String creatorName) {
        return new RollCallPlanEntity(id, name, beginDate, endDate, repetitiveRules, superviseDepartId, superviseDepartName, stationTypes, periodsOfTimes, organizationId, organizationInstitutional, organizationName, creatorId, creatorName);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getRepetitiveRule() {
        return this.repetitiveRule;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public String getStationTypes() {
        return this.stationTypes;
    }

    public String getPeriodsOfTimes() {
        return this.periodsOfTimes;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getOrganizationInstitutional() {
        return this.organizationInstitutional;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getLastUpdaterId() {
        return this.lastUpdaterId;
    }

    public String getLastUpdaterName() {
        return this.lastUpdaterName;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Timestamp getDeletedTime() {
        return this.deletedTime;
    }

    public int getCountOfInstances() {
        return this.countOfInstances;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setRepetitiveRule(int repetitiveRule) {
        this.repetitiveRule = repetitiveRule;
    }

    public void setSuperviseDepartId(String superviseDepartId) {
        this.superviseDepartId = superviseDepartId;
    }

    public void setSuperviseDepartName(String superviseDepartName) {
        this.superviseDepartName = superviseDepartName;
    }

    public void setStationTypes(String stationTypes) {
        this.stationTypes = stationTypes;
    }

    public void setPeriodsOfTimes(String periodsOfTimes) {
        this.periodsOfTimes = periodsOfTimes;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setOrganizationInstitutional(String organizationInstitutional) {
        this.organizationInstitutional = organizationInstitutional;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setLastUpdaterId(String lastUpdaterId) {
        this.lastUpdaterId = lastUpdaterId;
    }

    public void setLastUpdaterName(String lastUpdaterName) {
        this.lastUpdaterName = lastUpdaterName;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setDeletedTime(Timestamp deletedTime) {
        this.deletedTime = deletedTime;
    }

    public void setCountOfInstances(int countOfInstances) {
        this.countOfInstances = countOfInstances;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RollCallPlanEntity)) {
            return false;
        }
        RollCallPlanEntity other = (RollCallPlanEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getRepetitiveRule() != other.getRepetitiveRule()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        if (this.getCountOfInstances() != other.getCountOfInstances()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Date this$beginDate = this.getBeginDate();
        Date other$beginDate = other.getBeginDate();
        if (this$beginDate == null ? other$beginDate != null : !((Object)this$beginDate).equals(other$beginDate)) {
            return false;
        }
        Date this$endDate = this.getEndDate();
        Date other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        String this$superviseDepartId = this.getSuperviseDepartId();
        String other$superviseDepartId = other.getSuperviseDepartId();
        if (this$superviseDepartId == null ? other$superviseDepartId != null : !this$superviseDepartId.equals(other$superviseDepartId)) {
            return false;
        }
        String this$superviseDepartName = this.getSuperviseDepartName();
        String other$superviseDepartName = other.getSuperviseDepartName();
        if (this$superviseDepartName == null ? other$superviseDepartName != null : !this$superviseDepartName.equals(other$superviseDepartName)) {
            return false;
        }
        String this$stationTypes = this.getStationTypes();
        String other$stationTypes = other.getStationTypes();
        if (this$stationTypes == null ? other$stationTypes != null : !this$stationTypes.equals(other$stationTypes)) {
            return false;
        }
        String this$periodsOfTimes = this.getPeriodsOfTimes();
        String other$periodsOfTimes = other.getPeriodsOfTimes();
        if (this$periodsOfTimes == null ? other$periodsOfTimes != null : !this$periodsOfTimes.equals(other$periodsOfTimes)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$organizationInstitutional = this.getOrganizationInstitutional();
        String other$organizationInstitutional = other.getOrganizationInstitutional();
        if (this$organizationInstitutional == null ? other$organizationInstitutional != null : !this$organizationInstitutional.equals(other$organizationInstitutional)) {
            return false;
        }
        String this$organizationName = this.getOrganizationName();
        String other$organizationName = other.getOrganizationName();
        if (this$organizationName == null ? other$organizationName != null : !this$organizationName.equals(other$organizationName)) {
            return false;
        }
        String this$creatorId = this.getCreatorId();
        String other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !this$creatorId.equals(other$creatorId)) {
            return false;
        }
        String this$creatorName = this.getCreatorName();
        String other$creatorName = other.getCreatorName();
        if (this$creatorName == null ? other$creatorName != null : !this$creatorName.equals(other$creatorName)) {
            return false;
        }
        Timestamp this$lastUpdatedTime = this.getLastUpdatedTime();
        Timestamp other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$lastUpdaterId = this.getLastUpdaterId();
        String other$lastUpdaterId = other.getLastUpdaterId();
        if (this$lastUpdaterId == null ? other$lastUpdaterId != null : !this$lastUpdaterId.equals(other$lastUpdaterId)) {
            return false;
        }
        String this$lastUpdaterName = this.getLastUpdaterName();
        String other$lastUpdaterName = other.getLastUpdaterName();
        if (this$lastUpdaterName == null ? other$lastUpdaterName != null : !this$lastUpdaterName.equals(other$lastUpdaterName)) {
            return false;
        }
        Timestamp this$deletedTime = this.getDeletedTime();
        Timestamp other$deletedTime = other.getDeletedTime();
        return !(this$deletedTime == null ? other$deletedTime != null : !((Object)this$deletedTime).equals(other$deletedTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RollCallPlanEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRepetitiveRule();
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        result = result * 59 + this.getCountOfInstances();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Date $beginDate = this.getBeginDate();
        result = result * 59 + ($beginDate == null ? 43 : ((Object)$beginDate).hashCode());
        Date $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        String $superviseDepartId = this.getSuperviseDepartId();
        result = result * 59 + ($superviseDepartId == null ? 43 : $superviseDepartId.hashCode());
        String $superviseDepartName = this.getSuperviseDepartName();
        result = result * 59 + ($superviseDepartName == null ? 43 : $superviseDepartName.hashCode());
        String $stationTypes = this.getStationTypes();
        result = result * 59 + ($stationTypes == null ? 43 : $stationTypes.hashCode());
        String $periodsOfTimes = this.getPeriodsOfTimes();
        result = result * 59 + ($periodsOfTimes == null ? 43 : $periodsOfTimes.hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $organizationInstitutional = this.getOrganizationInstitutional();
        result = result * 59 + ($organizationInstitutional == null ? 43 : $organizationInstitutional.hashCode());
        String $organizationName = this.getOrganizationName();
        result = result * 59 + ($organizationName == null ? 43 : $organizationName.hashCode());
        String $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : $creatorId.hashCode());
        String $creatorName = this.getCreatorName();
        result = result * 59 + ($creatorName == null ? 43 : $creatorName.hashCode());
        Timestamp $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $lastUpdaterId = this.getLastUpdaterId();
        result = result * 59 + ($lastUpdaterId == null ? 43 : $lastUpdaterId.hashCode());
        String $lastUpdaterName = this.getLastUpdaterName();
        result = result * 59 + ($lastUpdaterName == null ? 43 : $lastUpdaterName.hashCode());
        Timestamp $deletedTime = this.getDeletedTime();
        result = result * 59 + ($deletedTime == null ? 43 : ((Object)$deletedTime).hashCode());
        return result;
    }

    public String toString() {
        return "RollCallPlanEntity(id=" + this.getId() + ", name=" + this.getName() + ", beginDate=" + this.getBeginDate() + ", endDate=" + this.getEndDate() + ", repetitiveRule=" + this.getRepetitiveRule() + ", superviseDepartId=" + this.getSuperviseDepartId() + ", superviseDepartName=" + this.getSuperviseDepartName() + ", stationTypes=" + this.getStationTypes() + ", periodsOfTimes=" + this.getPeriodsOfTimes() + ", createdTime=" + this.getCreatedTime() + ", organizationId=" + this.getOrganizationId() + ", organizationInstitutional=" + this.getOrganizationInstitutional() + ", organizationName=" + this.getOrganizationName() + ", creatorId=" + this.getCreatorId() + ", creatorName=" + this.getCreatorName() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", lastUpdaterId=" + this.getLastUpdaterId() + ", lastUpdaterName=" + this.getLastUpdaterName() + ", deleted=" + this.isDeleted() + ", deletedTime=" + this.getDeletedTime() + ", countOfInstances=" + this.getCountOfInstances() + ")";
    }
}

