/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.utils;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtil {
    public static RuntimeException unchecked(Exception e) {
        if (e instanceof RuntimeException) {
            RuntimeException ex = (RuntimeException)e;
            return ex;
        }
        return new RuntimeException(e);
    }

    public static String getStackTraceAsString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static boolean isCausedBy(Exception ex, Class<? extends Exception> ... causeExceptionClasses) {
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            for (Class<? extends Exception> causeClass : causeExceptionClasses) {
                if (!causeClass.isInstance(cause)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends Exception> T cast(Exception ex, Class<T> targetClass) {
        assert (ex != null);
        if (!targetClass.isAssignableFrom(ex.getClass())) {
            return null;
        }
        return (T)ex;
    }

    public static <T extends Exception> boolean is(Throwable ex, Class<T> targetClass) {
        assert (ex != null);
        return targetClass.isAssignableFrom(ex.getClass());
    }

    public static String getStackMessage(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
        }
        return sw.toString();
    }
}

