/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchReasonType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import org.springframework.data.annotation.Id;

@Document(language=SearchLanguage.CHINESE, timeToLive=43200L)
public class RoomDocument
extends EntityAbstract {
    @Id
    @Indexed
    private Long id;
    private String organizationId;
    private String employeeId;
    private Boolean activated;
    private DeskType deskType;
    private Timestamp leaveTime;
    private Timestamp createdTime;
    private CommunicatedType communicatedType;
    private int yardmanType;
    private DispatchReasonType referenceType;
    private String referenceNumber;
    private Collection<RoomUserDocument> roomUsers;

    public RoomDocument() {
        this.setActivated(true);
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static RoomDocument create(Long id, DeskType deskType, String organizationId, String employeeId, CommunicatedType communicatedType, int yardmanType, DispatchReasonType referenceType, String referenceNumber, Collection<RoomUserDocument> roomUsers) {
        RoomDocument document = new RoomDocument();
        document.setId(id);
        document.setEmployeeId(employeeId);
        document.setOrganizationId(organizationId);
        document.setCommunicatedType(communicatedType);
        document.setYardmanType(yardmanType);
        document.setDeskType(deskType);
        document.setReferenceType(referenceType);
        document.setReferenceNumber(referenceNumber);
        document.setRoomUsers(roomUsers);
        return document;
    }

    public void leave() {
        this.setActivated(false);
        this.setLeaveTime(Timestamp.from(Instant.now()));
    }

    public Long getId() {
        return this.id;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public Boolean getActivated() {
        return this.activated;
    }

    public DeskType getDeskType() {
        return this.deskType;
    }

    public Timestamp getLeaveTime() {
        return this.leaveTime;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public CommunicatedType getCommunicatedType() {
        return this.communicatedType;
    }

    public int getYardmanType() {
        return this.yardmanType;
    }

    public DispatchReasonType getReferenceType() {
        return this.referenceType;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public Collection<RoomUserDocument> getRoomUsers() {
        return this.roomUsers;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public void setActivated(Boolean activated) {
        this.activated = activated;
    }

    public void setDeskType(DeskType deskType) {
        this.deskType = deskType;
    }

    public void setLeaveTime(Timestamp leaveTime) {
        this.leaveTime = leaveTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public void setCommunicatedType(CommunicatedType communicatedType) {
        this.communicatedType = communicatedType;
    }

    public void setYardmanType(int yardmanType) {
        this.yardmanType = yardmanType;
    }

    public void setReferenceType(DispatchReasonType referenceType) {
        this.referenceType = referenceType;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public void setRoomUsers(Collection<RoomUserDocument> roomUsers) {
        this.roomUsers = roomUsers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoomDocument)) {
            return false;
        }
        RoomDocument other = (RoomDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getYardmanType() != other.getYardmanType()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$activated = this.getActivated();
        Boolean other$activated = other.getActivated();
        if (this$activated == null ? other$activated != null : !((Object)this$activated).equals(other$activated)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$employeeId = this.getEmployeeId();
        String other$employeeId = other.getEmployeeId();
        if (this$employeeId == null ? other$employeeId != null : !this$employeeId.equals(other$employeeId)) {
            return false;
        }
        DeskType this$deskType = this.getDeskType();
        DeskType other$deskType = other.getDeskType();
        if (this$deskType == null ? other$deskType != null : !this$deskType.equals(other$deskType)) {
            return false;
        }
        Timestamp this$leaveTime = this.getLeaveTime();
        Timestamp other$leaveTime = other.getLeaveTime();
        if (this$leaveTime == null ? other$leaveTime != null : !((Object)this$leaveTime).equals(other$leaveTime)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        CommunicatedType this$communicatedType = this.getCommunicatedType();
        CommunicatedType other$communicatedType = other.getCommunicatedType();
        if (this$communicatedType == null ? other$communicatedType != null : !this$communicatedType.equals(other$communicatedType)) {
            return false;
        }
        DispatchReasonType this$referenceType = this.getReferenceType();
        DispatchReasonType other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !this$referenceType.equals(other$referenceType)) {
            return false;
        }
        String this$referenceNumber = this.getReferenceNumber();
        String other$referenceNumber = other.getReferenceNumber();
        if (this$referenceNumber == null ? other$referenceNumber != null : !this$referenceNumber.equals(other$referenceNumber)) {
            return false;
        }
        Collection<RoomUserDocument> this$roomUsers = this.getRoomUsers();
        Collection<RoomUserDocument> other$roomUsers = other.getRoomUsers();
        return !(this$roomUsers == null ? other$roomUsers != null : !((Object)this$roomUsers).equals(other$roomUsers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoomDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getYardmanType();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $activated = this.getActivated();
        result = result * 59 + ($activated == null ? 43 : ((Object)$activated).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $employeeId = this.getEmployeeId();
        result = result * 59 + ($employeeId == null ? 43 : $employeeId.hashCode());
        DeskType $deskType = this.getDeskType();
        result = result * 59 + ($deskType == null ? 43 : $deskType.hashCode());
        Timestamp $leaveTime = this.getLeaveTime();
        result = result * 59 + ($leaveTime == null ? 43 : ((Object)$leaveTime).hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        CommunicatedType $communicatedType = this.getCommunicatedType();
        result = result * 59 + ($communicatedType == null ? 43 : $communicatedType.hashCode());
        DispatchReasonType $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : $referenceType.hashCode());
        String $referenceNumber = this.getReferenceNumber();
        result = result * 59 + ($referenceNumber == null ? 43 : $referenceNumber.hashCode());
        Collection<RoomUserDocument> $roomUsers = this.getRoomUsers();
        result = result * 59 + ($roomUsers == null ? 43 : ((Object)$roomUsers).hashCode());
        return result;
    }

    public String toString() {
        return "RoomDocument(id=" + this.getId() + ", organizationId=" + this.getOrganizationId() + ", employeeId=" + this.getEmployeeId() + ", activated=" + this.getActivated() + ", deskType=" + this.getDeskType() + ", leaveTime=" + this.getLeaveTime() + ", createdTime=" + this.getCreatedTime() + ", communicatedType=" + this.getCommunicatedType() + ", yardmanType=" + this.getYardmanType() + ", referenceType=" + this.getReferenceType() + ", referenceNumber=" + this.getReferenceNumber() + ", roomUsers=" + this.getRoomUsers() + ")";
    }

    public static class RoomUserDocument
    extends EntityAbstract {
        private String employeeId;
        private String tenantUserId;
        private String employeeName;
        private String organizationId;
        private String organizationName;
        private String tencentUserId;
        private String securityStationId;
        private String securityStationName;
        private String superviseDepartId;
        private String cid;
        private boolean isSponsor;

        public static RoomUserDocument create(String employeeId, String tenantUserId, String employeeName, String organizationId, String organizationName, String tencentUserId, String securityStationId, String securityStationName, String superviseDepartId, String cid, boolean isSponsor) {
            RoomUserDocument document = new RoomUserDocument();
            document.setOrganizationId(organizationId);
            document.setSponsor(isSponsor);
            document.setEmployeeId(employeeId);
            document.setEmployeeName(employeeName);
            document.setSuperviseDepartId(superviseDepartId);
            document.setOrganizationName(organizationName);
            document.setTencentUserId(tencentUserId);
            document.setSecurityStationId(securityStationId);
            document.setSecurityStationName(securityStationName);
            document.setCid(cid);
            document.setTenantUserId(tenantUserId);
            return document;
        }

        public String getEmployeeId() {
            return this.employeeId;
        }

        public String getTenantUserId() {
            return this.tenantUserId;
        }

        public String getEmployeeName() {
            return this.employeeName;
        }

        public String getOrganizationId() {
            return this.organizationId;
        }

        public String getOrganizationName() {
            return this.organizationName;
        }

        public String getTencentUserId() {
            return this.tencentUserId;
        }

        public String getSecurityStationId() {
            return this.securityStationId;
        }

        public String getSecurityStationName() {
            return this.securityStationName;
        }

        public String getSuperviseDepartId() {
            return this.superviseDepartId;
        }

        public String getCid() {
            return this.cid;
        }

        public boolean isSponsor() {
            return this.isSponsor;
        }

        public void setEmployeeId(String employeeId) {
            this.employeeId = employeeId;
        }

        public void setTenantUserId(String tenantUserId) {
            this.tenantUserId = tenantUserId;
        }

        public void setEmployeeName(String employeeName) {
            this.employeeName = employeeName;
        }

        public void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        public void setTencentUserId(String tencentUserId) {
            this.tencentUserId = tencentUserId;
        }

        public void setSecurityStationId(String securityStationId) {
            this.securityStationId = securityStationId;
        }

        public void setSecurityStationName(String securityStationName) {
            this.securityStationName = securityStationName;
        }

        public void setSuperviseDepartId(String superviseDepartId) {
            this.superviseDepartId = superviseDepartId;
        }

        public void setCid(String cid) {
            this.cid = cid;
        }

        public void setSponsor(boolean isSponsor) {
            this.isSponsor = isSponsor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoomUserDocument)) {
                return false;
            }
            RoomUserDocument other = (RoomUserDocument)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.isSponsor() != other.isSponsor()) {
                return false;
            }
            String this$employeeId = this.getEmployeeId();
            String other$employeeId = other.getEmployeeId();
            if (this$employeeId == null ? other$employeeId != null : !this$employeeId.equals(other$employeeId)) {
                return false;
            }
            String this$tenantUserId = this.getTenantUserId();
            String other$tenantUserId = other.getTenantUserId();
            if (this$tenantUserId == null ? other$tenantUserId != null : !this$tenantUserId.equals(other$tenantUserId)) {
                return false;
            }
            String this$employeeName = this.getEmployeeName();
            String other$employeeName = other.getEmployeeName();
            if (this$employeeName == null ? other$employeeName != null : !this$employeeName.equals(other$employeeName)) {
                return false;
            }
            String this$organizationId = this.getOrganizationId();
            String other$organizationId = other.getOrganizationId();
            if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
                return false;
            }
            String this$organizationName = this.getOrganizationName();
            String other$organizationName = other.getOrganizationName();
            if (this$organizationName == null ? other$organizationName != null : !this$organizationName.equals(other$organizationName)) {
                return false;
            }
            String this$tencentUserId = this.getTencentUserId();
            String other$tencentUserId = other.getTencentUserId();
            if (this$tencentUserId == null ? other$tencentUserId != null : !this$tencentUserId.equals(other$tencentUserId)) {
                return false;
            }
            String this$securityStationId = this.getSecurityStationId();
            String other$securityStationId = other.getSecurityStationId();
            if (this$securityStationId == null ? other$securityStationId != null : !this$securityStationId.equals(other$securityStationId)) {
                return false;
            }
            String this$securityStationName = this.getSecurityStationName();
            String other$securityStationName = other.getSecurityStationName();
            if (this$securityStationName == null ? other$securityStationName != null : !this$securityStationName.equals(other$securityStationName)) {
                return false;
            }
            String this$superviseDepartId = this.getSuperviseDepartId();
            String other$superviseDepartId = other.getSuperviseDepartId();
            if (this$superviseDepartId == null ? other$superviseDepartId != null : !this$superviseDepartId.equals(other$superviseDepartId)) {
                return false;
            }
            String this$cid = this.getCid();
            String other$cid = other.getCid();
            return !(this$cid == null ? other$cid != null : !this$cid.equals(other$cid));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RoomUserDocument;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSponsor() ? 79 : 97);
            String $employeeId = this.getEmployeeId();
            result = result * 59 + ($employeeId == null ? 43 : $employeeId.hashCode());
            String $tenantUserId = this.getTenantUserId();
            result = result * 59 + ($tenantUserId == null ? 43 : $tenantUserId.hashCode());
            String $employeeName = this.getEmployeeName();
            result = result * 59 + ($employeeName == null ? 43 : $employeeName.hashCode());
            String $organizationId = this.getOrganizationId();
            result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
            String $organizationName = this.getOrganizationName();
            result = result * 59 + ($organizationName == null ? 43 : $organizationName.hashCode());
            String $tencentUserId = this.getTencentUserId();
            result = result * 59 + ($tencentUserId == null ? 43 : $tencentUserId.hashCode());
            String $securityStationId = this.getSecurityStationId();
            result = result * 59 + ($securityStationId == null ? 43 : $securityStationId.hashCode());
            String $securityStationName = this.getSecurityStationName();
            result = result * 59 + ($securityStationName == null ? 43 : $securityStationName.hashCode());
            String $superviseDepartId = this.getSuperviseDepartId();
            result = result * 59 + ($superviseDepartId == null ? 43 : $superviseDepartId.hashCode());
            String $cid = this.getCid();
            result = result * 59 + ($cid == null ? 43 : $cid.hashCode());
            return result;
        }

        public String toString() {
            return "RoomDocument.RoomUserDocument(employeeId=" + this.getEmployeeId() + ", tenantUserId=" + this.getTenantUserId() + ", employeeName=" + this.getEmployeeName() + ", organizationId=" + this.getOrganizationId() + ", organizationName=" + this.getOrganizationName() + ", tencentUserId=" + this.getTencentUserId() + ", securityStationId=" + this.getSecurityStationId() + ", securityStationName=" + this.getSecurityStationName() + ", superviseDepartId=" + this.getSuperviseDepartId() + ", cid=" + this.getCid() + ", isSponsor=" + this.isSponsor() + ")";
        }
    }
}

