/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.dubbo.common.configs;

import com.bcxin.tenant.open.dubbo.common.configs.DubboConfigProperty;
import com.bcxin.tenant.open.infrastructures.InjectResolver;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.valueTypes.TrafficTagValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.dubbo.config.ProviderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class CommonConfig
implements BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(CommonConfig.class);

    @Bean
    public ProviderConfig providerConfig(DubboConfigProperty property) {
        ProviderConfig config = new ProviderConfig();
        config.setVersion(property.getVersion());
        return config;
    }

    @Bean
    public JsonProvider jsonProvider() {
        return new JsonProvider.DefaultJsonProvider();
    }

    @Bean
    public TrafficTagValueType trafficTagValueType(@Value(value="${dubbo.provider.tag:null}") String tagLabel) {
        Collection tags = new ArrayList();
        if (StringUtils.hasLength((String)tagLabel)) {
            tags = Arrays.stream(tagLabel.split(";")).filter(ii -> StringUtils.hasLength((String)ii)).collect(Collectors.toList());
        }
        logger.error("\u5f53\u524d\u7684dubbo.provider.tag\u6d41\u91cf\u4fe1\u606f\u4e3a:{}", (Object)tagLabel);
        return TrafficTagValueType.create(tags);
    }

    public void setBeanFactory(final BeanFactory beanFactory) throws BeansException {
        TenantContext.getInstance().setInjectResolver(new InjectResolver(){

            public <T> T resolve(Class<T> tClass) {
                return (T)beanFactory.getBean(tClass);
            }

            public <T> Collection<T> resolveAll(Class<T> tClass) {
                return Collections.singleton(beanFactory.getBean(tClass));
            }
        });
    }
}

