/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.utils.ftp;

import com.bcxin.backend.domain.configs.FileModeConfig;
import com.bcxin.backend.domain.utils.ftp.FtpConnection;
import com.bcxin.backend.domain.utils.ftp.FtpFactory;
import com.bcxin.backend.domain.utils.ftp.UploadResult;
import com.bcxin.backend.domain.utils.ftp.UploadTask;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class FtpUtil {
    private static final Logger logger = LoggerFactory.getLogger(FtpUtil.class);

    public static synchronized List<UploadResult> upload(String ftpPath, File[] listFiles) {
        ExecutorService newFixedThreadPool = Executors.newFixedThreadPool(FileModeConfig.threadPoolSize);
        ArrayList results = new ArrayList();
        FtpFactory factory = new FtpFactory();
        List<Object> listResults = new ArrayList();
        Exception lastException = null;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            long a = System.currentTimeMillis();
            for (File file : listFiles) {
                long createTime;
                if (file.isDirectory() || (a - (createTime = file.lastModified())) / 60L / 1000L < 5L) continue;
                FtpConnection ftp = factory.getFtp();
                UploadTask upload = new UploadTask(factory, ftp, file, ftpPath, file.getName());
                Future submit = newFixedThreadPool.submit(upload);
                results.add(submit);
            }
            listResults = results.parallelStream().map(result -> {
                try {
                    return (UploadResult)result.get(30L, TimeUnit.MINUTES);
                }
                catch (Exception ex) {
                    logger.error("\u83b7\u53d6\u4e0a\u4f20FTP\u7ed3\u679c\u5f02\u5e38", (Throwable)ex);
                    return null;
                }
            }).collect(Collectors.toList());
            factory.close();
            newFixedThreadPool.shutdown();
        }
        catch (Exception ex) {
            try {
                lastException = ex;
                throw ex;
            }
            catch (Throwable throwable) {
                factory.close();
                newFixedThreadPool.shutdown();
                stopWatch.stop();
                logger.error("\u5b8c\u6210({})FTP\u7684\u6267\u884c(\u9884\u671f\u6570={}, \u5b9e\u9645\u54cd\u5e94\u6570={}),\u8017\u65f6:{}\u79d2", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", results.size(), listResults.size(), stopWatch.getTotalTimeSeconds(), lastException});
                throw throwable;
            }
        }
        stopWatch.stop();
        logger.error("\u5b8c\u6210({})FTP\u7684\u6267\u884c(\u9884\u671f\u6570={}, \u5b9e\u9645\u54cd\u5e94\u6570={}),\u8017\u65f6:{}\u79d2", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", results.size(), listResults.size(), stopWatch.getTotalTimeSeconds(), lastException});
        return listResults;
    }

    public static boolean uploadBase64(String ftpPath, String ftpFileName, String base64Content) {
        boolean result = false;
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            result = ftp.uploadBase64(ftpPath, ftpFileName, base64Content);
        }
        catch (IOException e) {
            logger.error("=======>\u4e0a\u4f20base64\u6587\u4ef6(ftpPath={}, fileName={})\u5931\u8d25ftp\u5f02\u5e38", new Object[]{ftpPath, ftpFileName, e});
        }
        return result;
    }

    public static boolean downloadFile(String path, String filename, File dstFile) {
        boolean result = false;
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            result = ftp.download(path, filename, dstFile);
        }
        catch (IOException e) {
            logger.error("=======>downloadFile\u6587\u4ef6(path={}, filename={})\u5931\u8d25ftp\u5f02\u5e38", new Object[]{path, filename, e});
        }
        return result;
    }

    public static String downloadAsBase64(String path, String filename) {
        String result = "";
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            result = ftp.downloadAsBase64(path, filename);
        }
        catch (IOException e) {
            logger.error("=======>downloadAsBase64(path={}, filename={})\u5931\u8d25ftp\u5f02\u5e38", new Object[]{path, filename, e});
        }
        return result;
    }

    public static List<String> filenames(String path, String keywork) {
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            return ftp.fileNames(path, keywork);
        }
        catch (IOException e) {
            logger.error("=======>filenames(path={}, filename={})\u5931\u8d25ftp\u5f02\u5e38", new Object[]{path, keywork, e});
            return new ArrayList<String>();
        }
    }

    public static boolean delFilename(String path, String filename) {
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            return ftp.delectFile(path, filename);
        }
        catch (IOException e) {
            logger.error("=======>delFilename(path={}, filename={})\u5931\u8d25ftp\u5f02\u5e38", new Object[]{path, filename, e});
            return false;
        }
    }

    public static String getFileContent(String path, String ftpFileName) {
        try {
            FtpFactory factory = new FtpFactory();
            FtpConnection ftp = factory.getFtp();
            return ftp.getFileContent(path, ftpFileName);
        }
        catch (IOException e) {
            logger.error("=======>getFileContent(path={}, filename={})\u5931\u8d25ftp\u5f02\u5e38", new Object[]{path, ftpFileName, e});
            return "";
        }
    }
}

