/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.table.tasks.webhookConfigs;

import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.DefinitionAbstract;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigSourceDefinition;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigSourceType;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.types.Row;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class WebHookConfigSourceMetaDefinition
extends DefinitionAbstract {
    private String refSourceName;
    private String refSourceTableName;
    private String tableName;
    private boolean isSource;
    private Collection<WebHookConfigSourceMetaColumnDefinition> columns;

    public String getInsertSql(Row row) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("INSERT INTO %s", this.getTableName()));
        sb.append("(");
        StringBuilder value = new StringBuilder();
        value.append("(");
        List columnDefinitions = this.getColumns().stream().filter(ii -> !ii.isConstraintDefinition()).collect(Collectors.toList());
        for (int index = 0; index < columnDefinitions.size(); ++index) {
            WebHookConfigSourceMetaColumnDefinition columnDefinition = (WebHookConfigSourceMetaColumnDefinition)columnDefinitions.get(index);
            String columnName = columnDefinition.getName();
            sb.append(columnName);
            value.append(String.format("'%s'", row.getField(columnName)));
            if (index >= columnDefinitions.size() - 1) continue;
            sb.append(",");
            value.append(",");
        }
        value.append(")");
        sb.append(")VALUES");
        sb.append((CharSequence)value);
        return sb.toString();
    }

    public boolean IsHttpConfig(Collection<WebHookConfigSourceDefinition> sourceDefinitions) {
        if (CollectionUtils.isEmpty(sourceDefinitions) || !StringUtils.hasLength((String)this.getRefSourceName())) {
            return false;
        }
        return sourceDefinitions.stream().anyMatch(ii -> ii.getName().equalsIgnoreCase(this.getRefSourceName()) && ii.getType() == WebHookConfigSourceType.HttpSink);
    }

    public String getSql() {
        return "";
    }

    public String getRefSourceName() {
        return this.refSourceName;
    }

    public String getRefSourceTableName() {
        return this.refSourceTableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isSource() {
        return this.isSource;
    }

    public Collection<WebHookConfigSourceMetaColumnDefinition> getColumns() {
        return this.columns;
    }

    public void setRefSourceName(String refSourceName) {
        this.refSourceName = refSourceName;
    }

    public void setRefSourceTableName(String refSourceTableName) {
        this.refSourceTableName = refSourceTableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setSource(boolean isSource) {
        this.isSource = isSource;
    }

    public void setColumns(Collection<WebHookConfigSourceMetaColumnDefinition> columns) {
        this.columns = columns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebHookConfigSourceMetaDefinition)) {
            return false;
        }
        WebHookConfigSourceMetaDefinition other = (WebHookConfigSourceMetaDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSource() != other.isSource()) {
            return false;
        }
        String this$refSourceName = this.getRefSourceName();
        String other$refSourceName = other.getRefSourceName();
        if (this$refSourceName == null ? other$refSourceName != null : !this$refSourceName.equals(other$refSourceName)) {
            return false;
        }
        String this$refSourceTableName = this.getRefSourceTableName();
        String other$refSourceTableName = other.getRefSourceTableName();
        if (this$refSourceTableName == null ? other$refSourceTableName != null : !this$refSourceTableName.equals(other$refSourceTableName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        Collection<WebHookConfigSourceMetaColumnDefinition> this$columns = this.getColumns();
        Collection<WebHookConfigSourceMetaColumnDefinition> other$columns = other.getColumns();
        return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebHookConfigSourceMetaDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSource() ? 79 : 97);
        String $refSourceName = this.getRefSourceName();
        result = result * 59 + ($refSourceName == null ? 43 : $refSourceName.hashCode());
        String $refSourceTableName = this.getRefSourceTableName();
        result = result * 59 + ($refSourceTableName == null ? 43 : $refSourceTableName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        Collection<WebHookConfigSourceMetaColumnDefinition> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        return result;
    }

    public String toString() {
        return "WebHookConfigSourceMetaDefinition(refSourceName=" + this.getRefSourceName() + ", refSourceTableName=" + this.getRefSourceTableName() + ", tableName=" + this.getTableName() + ", isSource=" + this.isSource() + ", columns=" + this.getColumns() + ")";
    }

    public static class WebHookConfigSourceMetaColumnDefinition
    extends DefinitionAbstract {
        private String name;
        private String type;
        private boolean constraintDefinition;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isConstraintDefinition() {
            return this.constraintDefinition;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setConstraintDefinition(boolean constraintDefinition) {
            this.constraintDefinition = constraintDefinition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WebHookConfigSourceMetaColumnDefinition)) {
                return false;
            }
            WebHookConfigSourceMetaColumnDefinition other = (WebHookConfigSourceMetaColumnDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isConstraintDefinition() != other.isConstraintDefinition()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WebHookConfigSourceMetaColumnDefinition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isConstraintDefinition() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "WebHookConfigSourceMetaDefinition.WebHookConfigSourceMetaColumnDefinition(name=" + this.getName() + ", type=" + this.getType() + ", constraintDefinition=" + this.isConstraintDefinition() + ")";
        }
    }
}

