/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.table.tasks.webhookConfigs;

import com.bcxin.event.core.exceptions.NoFoundEventException;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.DefinitionAbstract;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigExecuteDefinition;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigSourceDefinition;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigSourceMetaDefinition;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigSourceType;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class WebHookConfigDefinition
extends DefinitionAbstract {
    private String name;
    private String groupId;
    private Collection<WebHookConfigSourceDefinition> sources;
    private Collection<WebHookConfigSourceMetaDefinition> metaDefinitions;
    private WebHookConfigExecuteDefinition executeDefinition;

    public Collection<String> getHookConfigSourceSql() {
        if (CollectionUtils.isEmpty(this.getSources())) {
            return Collections.EMPTY_LIST;
        }
        Collection batchSql = this.getMetaDefinitions().stream().map(meta -> {
            Optional<WebHookConfigSourceDefinition> selectedSourceOptional = this.getSources().stream().filter(sr -> sr.getName().equalsIgnoreCase(meta.getRefSourceName())).findFirst();
            if (!selectedSourceOptional.isPresent()) {
                throw new NoFoundEventException("\u65e0\u6548\u7684Source\u4fe1\u606f");
            }
            if (selectedSourceOptional.get().getType() == WebHookConfigSourceType.HttpSink) {
                return null;
            }
            WebHookConfigSourceDefinition selectedSource = selectedSourceOptional.get();
            return selectedSource.getType().generateSql(this, selectedSource, (WebHookConfigSourceMetaDefinition)meta);
        }).filter(ii -> StringUtils.hasLength((String)ii)).collect(Collectors.toList());
        return batchSql;
    }

    public String getName() {
        return this.name;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Collection<WebHookConfigSourceDefinition> getSources() {
        return this.sources;
    }

    public Collection<WebHookConfigSourceMetaDefinition> getMetaDefinitions() {
        return this.metaDefinitions;
    }

    public WebHookConfigExecuteDefinition getExecuteDefinition() {
        return this.executeDefinition;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setSources(Collection<WebHookConfigSourceDefinition> sources) {
        this.sources = sources;
    }

    public void setMetaDefinitions(Collection<WebHookConfigSourceMetaDefinition> metaDefinitions) {
        this.metaDefinitions = metaDefinitions;
    }

    public void setExecuteDefinition(WebHookConfigExecuteDefinition executeDefinition) {
        this.executeDefinition = executeDefinition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebHookConfigDefinition)) {
            return false;
        }
        WebHookConfigDefinition other = (WebHookConfigDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        Collection<WebHookConfigSourceDefinition> this$sources = this.getSources();
        Collection<WebHookConfigSourceDefinition> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        Collection<WebHookConfigSourceMetaDefinition> this$metaDefinitions = this.getMetaDefinitions();
        Collection<WebHookConfigSourceMetaDefinition> other$metaDefinitions = other.getMetaDefinitions();
        if (this$metaDefinitions == null ? other$metaDefinitions != null : !((Object)this$metaDefinitions).equals(other$metaDefinitions)) {
            return false;
        }
        WebHookConfigExecuteDefinition this$executeDefinition = this.getExecuteDefinition();
        WebHookConfigExecuteDefinition other$executeDefinition = other.getExecuteDefinition();
        return !(this$executeDefinition == null ? other$executeDefinition != null : !((Object)this$executeDefinition).equals(other$executeDefinition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebHookConfigDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        Collection<WebHookConfigSourceDefinition> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        Collection<WebHookConfigSourceMetaDefinition> $metaDefinitions = this.getMetaDefinitions();
        result = result * 59 + ($metaDefinitions == null ? 43 : ((Object)$metaDefinitions).hashCode());
        WebHookConfigExecuteDefinition $executeDefinition = this.getExecuteDefinition();
        result = result * 59 + ($executeDefinition == null ? 43 : ((Object)$executeDefinition).hashCode());
        return result;
    }

    public String toString() {
        return "WebHookConfigDefinition(name=" + this.getName() + ", groupId=" + this.getGroupId() + ", sources=" + this.getSources() + ", metaDefinitions=" + this.getMetaDefinitions() + ", executeDefinition=" + this.getExecuteDefinition() + ")";
    }
}

