/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.table.tasks.components.httpsink;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.tenant.data.etc.table.tasks.utils.JwtUtil;
import com.bcxin.tenant.data.etc.table.tasks.webhookConfigs.WebHookConfigSourceDefinition;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class WebHttpSinkWriter
implements SinkWriter<String> {
    private static final Logger logger = LoggerFactory.getLogger(WebHttpSinkWriter.class);
    private final List<String> bulkRequests = new ArrayList<String>();
    private transient CloseableHttpClient httpClient = null;
    private final int batchSize;
    private final int batchIntervalMs;
    private final JsonProvider jsonProvider;
    private final WebHookConfigSourceDefinition configSourceDefinition;

    public WebHttpSinkWriter(int batchSize, int batchIntervalMs, WebHookConfigSourceDefinition configSourceDefinition) {
        this.configSourceDefinition = configSourceDefinition;
        this.batchSize = batchSize < 10 ? 500 : batchSize;
        this.batchIntervalMs = batchIntervalMs < 500 ? 5000 : batchIntervalMs;
        this.jsonProvider = new JsonProviderImpl();
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleAtFixedRate(() -> {
            try {
                this.flush(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.error("\u6267\u884c\u6570\u636e\u63a8\u9001\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            }
        }, batchIntervalMs, batchIntervalMs, TimeUnit.MICROSECONDS);
        this.httpClient = HttpClients.createDefault();
    }

    public synchronized void write(String element, SinkWriter.Context context) throws IOException, InterruptedException {
        this.bulkRequests.add(element);
        if (this.batchSize <= 0 || this.batchSize > this.bulkRequests.size()) {
            // empty if block
        }
        this.flush(true);
    }

    public synchronized void flush(boolean endOfInput) {
        if (CollectionUtils.isEmpty(this.bulkRequests)) {
            return;
        }
        try {
            String api = this.configSourceDefinition.getConf();
            this.doExecute(api, this.bulkRequests);
            this.bulkRequests.clear();
            logger.error("\u6210\u529f\u63d0\u4ea4\u5b8c\u6bd5\u5e76\u6e05\u695abulkRequests={}", (Object)this.bulkRequests.size());
        }
        catch (Exception ex) {
            throw new BadEventException("\u6267\u884cHttp Sink\u53d1\u751f\u5f02\u5e38", ex);
        }
    }

    public void close() throws Exception {
        this.httpClient.close();
    }

    private void doExecute(String api, List<String> parameters) throws IOException {
        String body = null;
        try {
            Collection params = parameters.stream().map(ii -> {
                JSONObject data = (JSONObject)this.jsonProvider.toObject(JSONObject.class, ii);
                return data;
            }).collect(Collectors.toList());
            body = this.jsonProvider.getJson((Object)params);
            HttpPost post = new HttpPost(api);
            StringEntity httpEntity = new StringEntity(body, "UTF-8");
            httpEntity.setContentEncoding(StandardCharsets.UTF_8.toString());
            httpEntity.setContentType("application/json");
            if (!CollectionUtils.isEmpty(this.configSourceDefinition.getExtendMap())) {
                for (String key : this.configSourceDefinition.getExtendMap().keySet()) {
                    String headValue = this.configSourceDefinition.getMapValue(key);
                    if (!"gid.connector.http.sink.user.id".equalsIgnoreCase(key)) continue;
                    post.setHeader("accessToken", JwtUtil.getToken(headValue));
                }
            }
            post.setEntity((HttpEntity)httpEntity);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() != 200) {
                    String content = EntityUtils.toString((HttpEntity)response.getEntity());
                    logger.error("\u6267\u884c\u7ed3\u675f(\u603b\u6570\u91cf={}):{} \u5931\u8d25-\u72b6\u6001:{} \u8bf7\u6c42-{}; \u54cd\u5e94:{}", new Object[]{this.bulkRequests.size(), api, statusLine.getStatusCode(), body, content});
                } else {
                    logger.error("\u6210\u529f-\u6267\u884c\u7ed3\u675f(\u603b\u6570\u91cf={}):{} \u8bf7\u6c42-{} Ok-\u54cd\u5e94:{}", new Object[]{this.bulkRequests.size(), api, body, statusLine.getStatusCode()});
                }
            }
        }
        catch (Exception ex) {
            logger.error("WebHttpSink\u8c03\u7528(body={})\u53d1\u751f\u5f02\u5e38:{}", body, (Object)ExceptionUtils.getMessage((Throwable)ex));
            throw ex;
        }
    }

    public List<String> getBulkRequests() {
        return this.bulkRequests;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getBatchIntervalMs() {
        return this.batchIntervalMs;
    }

    public JsonProvider getJsonProvider() {
        return this.jsonProvider;
    }

    public WebHookConfigSourceDefinition getConfigSourceDefinition() {
        return this.configSourceDefinition;
    }
}

