/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.table.tasks.components.httpsink;

import com.getindata.connectors.http.internal.sink.httpclient.HttpRequest;
import com.getindata.connectors.http.internal.table.sink.Slf4jHttpPostRequestCallback;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHttpPostRequestCallback
extends Slf4jHttpPostRequestCallback {
    private static final Logger log = LoggerFactory.getLogger(CustomHttpPostRequestCallback.class);

    public void call(HttpResponse<String> response, HttpRequest requestEntry, String endpointUrl, Map<String, String> headerMap) {
        try {
            super.call(response, requestEntry, endpointUrl, headerMap);
            List requestElements = requestEntry.getElements();
            String requestBody = requestElements.stream().map(element -> new String((byte[])element, StandardCharsets.UTF_8)).collect(Collectors.joining());
            if (response == null) {
                log.error("[\u72b6\u6001={}]-\u5206\u53d1\u8ba2\u9605\u6570\u636e\u81f3{}; \u8bf7\u6c42\u65b9\u6cd5= {}\n    \u8bf7\u6c42Body={}\n  Response: null", new Object[]{response.statusCode(), endpointUrl, requestEntry.getMethod(), requestBody});
            } else {
                log.error("[\u72b6\u6001={}]-\u5206\u53d1\u8ba2\u9605\u6570\u636e\u81f3{}; \u8bf7\u6c42\u65b9\u6cd5= {}\n    \u8bf7\u6c42Body= {}\n  \u54cd\u5e94\u5185\u5bb9: {}\n    Body: {}", new Object[]{response.statusCode(), endpointUrl, requestEntry.method, requestBody, response, response.body().replaceAll("\\R", "")});
            }
        }
        catch (Exception ex) {
            log.error("\u6267\u884cCustomHttpPostRequestCallback(\u54cd\u5e94={})\u53d1\u751f\u5f02\u5e38:{}", new Object[]{response, response.body(), ex});
        }
    }
}

