/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.data.etc.table.tasks.components;

import com.bcxin.tenant.data.etc.table.tasks.components.RedisDynamicTableSourceFactory;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.connectors.redis.RedisSink;
import org.apache.flink.streaming.connectors.redis.common.config.FlinkJedisConfigBase;
import org.apache.flink.streaming.connectors.redis.common.config.FlinkJedisPoolConfig;
import org.apache.flink.streaming.connectors.redis.common.mapper.RedisCommand;
import org.apache.flink.streaming.connectors.redis.common.mapper.RedisCommandDescription;
import org.apache.flink.streaming.connectors.redis.common.mapper.RedisMapper;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;

public class RedisDynamicTableSink
implements DynamicTableSink {
    private ReadableConfig options;

    public RedisDynamicTableSink(ReadableConfig options) {
        this.options = options;
    }

    public ChangelogMode getChangelogMode(ChangelogMode changelogMode) {
        return ChangelogMode.insertOnly();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        String host = (String)this.options.get(RedisDynamicTableSourceFactory.host);
        FlinkJedisPoolConfig.Builder builder = new FlinkJedisPoolConfig.Builder().setHost(host);
        Integer port = (Integer)this.options.get(RedisDynamicTableSourceFactory.port);
        if (port != null) {
            builder.setPort(port.intValue());
        }
        FlinkJedisPoolConfig build = builder.build();
        RedisMapper<RowData> stringRedisMapper = new RedisMapper<RowData>(){

            public RedisCommandDescription getCommandDescription() {
                return new RedisCommandDescription(RedisCommand.SET);
            }

            public String getKeyFromData(RowData rowData) {
                StringData string = rowData.getString(0);
                return string.toString();
            }

            public String getValueFromData(RowData rowData) {
                String s = rowData.toString();
                return s;
            }
        };
        RedisSink stringRedisSink = new RedisSink((FlinkJedisConfigBase)build, (RedisMapper)stringRedisMapper);
        return SinkFunctionProvider.of((SinkFunction)stringRedisSink);
    }

    public DynamicTableSink copy() {
        return new RedisDynamicTableSink(this.options);
    }

    public String asSummaryString() {
        return "my_redis_sink";
    }
}

