package com.bcxin.event.job.domain.repositories.criterias;

import com.bcxin.event.core.CriteriaAbstract;
import lombok.Data;

@Data
public class JobMetaCriteria extends CriteriaAbstract {
    private String keyword;

    public static JobMetaCriteria create(String keyword, int pageIndex, int pageSize) {
        JobMetaCriteria criteria = new JobMetaCriteria();
        criteria.setPageSize(pageSize < 0 ? 10 : pageSize);
        criteria.setPageIndex(pageIndex < 1 ? 1 : pageIndex);
        criteria.setKeyword(keyword);

        return criteria;
    }

    public static JobMetaCriteria create(String keyword) {
        return JobMetaCriteria.create(keyword, 1, 10);
    }
}
