package com.bcxin.rest.web.commons;

import cn.hutool.core.io.FileUtil;
import com.bcxin.Infrastructures.TenantConfigProperty;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.UUID;

public interface FileProcessor {
    String save(MultipartFile file);

    @Component
    public static class FileProcessorImpl implements FileProcessor {
        private final TenantConfigProperty configProperty;

        public FileProcessorImpl(TenantConfigProperty configProperty) {
            this.configProperty = configProperty;
        }

        @Override
        public String save(MultipartFile file) {

            String relativePath = String.format("/uploads/%s/%s", UUID.randomUUID(), file.getOriginalFilename());
            String destFileName = String.format("%s/%s", configProperty.getUpload().getPath(),relativePath);
            File destFile = new File(destFileName);
            FileUtil.mkdir(destFile.getParentFile());
            try {
                destFile.createNewFile();
                file.transferTo(destFile);
            } catch (IOException e) {
                throw new BadTenantException("文件创建失败");
            }

            return relativePath;
        }
    }
}
