DROP TABLE IF EXISTS `eb_biaozhunbandingdan`;
CREATE TABLE `eb_biaozhunbandingdan` (
`id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
`user_id` int(11) NOT NULL DEFAULT '0' COMMENT '创建用户id',
`update_user_id` int(11) NOT NULL DEFAULT '0' COMMENT '修改用户id',
`owner_user_id` int(11) NOT NULL DEFAULT '0' COMMENT '所属用户id',
`dingdanbianhao` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '订单编号',
`shifujine` decimal(10,2) DEFAULT NULL COMMENT '实付金额',
`frame_id` int(11) NOT NULL DEFAULT '0' COMMENT '部门ID',
`created_at` timestamp NULL DEFAULT NULL,
`updated_at` timestamp NULL DEFAULT NULL,
`deleted_at` timestamp NULL DEFAULT NULL,
PRIMARY KEY (`id`),
UNIQUE KEY `dingdanbianhao` (`dingdanbianhao`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- #用户
INSERT INTO `eb_system_crud` (`id`, `table_name`, `table_name_en`, `cate_ids`, `info`, `crud_id`, `user_id`, `is_update_form`, `is_update_table`, `form_fields`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, '用户', 'admin', '', '', 0, '4', 0, 0, '[\"account\",\"avatar\",\"phone\",\"job\",\"name\",\"password\",\"is_admin\",\"roles\",\"uni_online\",\"mark\",\"client_id\"]', '2024-05-20 16:14:57', '2024-05-20 17:21:03', NULL);
SELECT @yongHuCrudId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @yongHuCrudId, '主键ID', 'id', 'input_number', 'int', 0, 0, '主键ID', '', 0, 0, 0, 0, 'admin664b06813730f', '', '', 1, 1, 1, '2024-05-20 16:14:57', '2024-05-20 17:21:03', NULL),
(null, @yongHuCrudId, '创建时间', 'created_at', 'date_time_picker', 'timestamp', 1, 0, '创建时间', 'status', 0, 0, 0, 0, 'admin664b068137342', '', '', 1, 1, 1, '2024-05-20 16:14:57', '2024-05-20 17:21:03', NULL),
(null, @yongHuCrudId, '修改时间', 'updated_at', 'date_time_picker', 'timestamp', 1, 0, '修改时间', 'created_at', 0, 0, 0, 0, 'admin664b06813734d', '', '', 1, 1, 1, '2024-05-20 16:14:57', '2024-05-20 17:21:03', NULL),
(null, @yongHuCrudId, '伪删除', 'deleted_at', 'date_time_picker', 'timestamp', 1, 0, '伪删除', 'updated_at', 0, 0, 0, 0, 'admin664b068137355', '', '', 1, 1, 1, '2024-05-20 16:14:57', '2024-05-20 17:21:03', NULL),
(null, @yongHuCrudId, 'UID', 'uid', 'input', 'varchar', 1, 1, 'UID', 'owner_user_id', 0, 0, 0, 0, 'admin664b070d2ebc5', '[]', '[]', 0, 0, 1, '2024-05-20 16:17:17', '2024-05-20 17:21:03', NULL);

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @yongHuCrudId, '用户账号', 'account', 'input', 'varchar', 1, 1, '用户账号', 'uid', 0, 0, 0, 1, 'admin664b072702318', '[]', '[]', 1, 1, 1, '2024-05-20 16:17:43', '2024-05-20 17:21:03', NULL);
SELECT @yongHuYongHuZhangHaoFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @yongHuCrudId, '用户头像', 'avatar', 'image', 'text', 1, 1, '用户头像', 'password', 0, 0, 0, 1, 'admin664b0bd244999', '[]', '{\"max\":\"1\",\"size\":\"5\"}', 1, 1, 1, '2024-05-20 16:37:38', '2024-05-20 17:21:03', NULL);
SELECT @yongHuYongHuTouXiangFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @yongHuCrudId, '用户姓名', 'name', 'input', 'varchar', 1, 1, '用户姓名', 'avatar', 0, 0, 1, 1, 'admin664b0c17cf61b', '[]', '{\"maxlength\":\"20\"}', 1, 1, 1, '2024-05-20 16:38:47', '2024-05-20 17:21:03', NULL);
SELECT @yongHuYongHuXingMingFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @yongHuCrudId, '手机号', 'phone', 'input', 'varchar', 1, 1, '手机号', 'name', 0, 0, 0, 1, 'admin664b0c280089d', '[]', '{\"maxlength\":\"11\"}', 1, 1, 1, '2024-05-20 16:39:04', '2024-05-20 17:21:03', NULL);
SELECT @yongHuShouJiHaoFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @yongHuCrudId, '职位ID', 'job', 'input_number', 'int', 1, 1, '职位ID', 'phone', 0, 0, 0, 1, 'admin664b0ca41de64', '[]', '[]', 1, 1, 1, '2024-05-20 16:41:08', '2024-05-20 17:21:03', NULL);
SELECT @yongHuZhiWeiIDFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @yongHuCrudId, '访问ip', 'last_ip', 'input', 'varchar', 1, 1, '访问ip', 'scan_key', 0, 0, 0, 0, 'admin664b0cfbc834e', '[]', '[]', 1, 1, 1, '2024-05-20 16:42:35', '2024-05-20 17:21:03', NULL),
(null, @yongHuCrudId, '登陆次数', 'login_count', 'input_number', 'int', 1, 1, '登陆次数', 'last_ip', 0, 0, 0, 0, 'admin664b0d0b5b174', '[]', '[]', 1, 1, 1, '2024-05-20 16:42:51', '2024-05-20 17:21:03', NULL),
(null, @yongHuCrudId, '是否为初始密码', 'is_init', 'input_number', 'int', 1, 1, '是否为初始密码', 'login_count', 0, 0, 0, 0, 'admin664b0d4559f37', '[]', '[]', 1, 1, 1, '2024-05-20 16:43:49', '2024-05-20 17:21:03', NULL);

INSERT INTO `eb_system_crud_form` (`id`, `crud_id`, `version`, `options`, `fields`, `global_options`, `is_index`, `created_at`, `updated_at`, `deleted_at`) VALUES

(null, @yongHuCrudId, 1, CONCAT('[{"name":"\\u7528\\u6237\\u8d26\\u53f7","type":"input","icon":"text-field","formItemFlag":true,"options":{"name":"account","label":"\\u7528\\u6237\\u8d26\\u53f7","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @yongHuYongHuZhangHaoFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","formFieldUniqid":"account"},"hide":false,"id":"input54795","i":"3","pidx":"0"},{"name":"\\u7528\\u6237\\u5934\\u50cf","type":"image","icon":"picture-upload-field","formItemFlag":true,"options":{"name":"avatar","label":"\\u7528\\u6237\\u5934\\u50cf","labelAlign":"","type":"","defaultValue":[],"placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @yongHuYongHuTouXiangFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","uploadURL":"Common\/upload","uploadTip":"","withCredentials":false,"multipleSelect":false,"showFileList":false,"limit":"1","fileMaxSize":"5","fileTypes":["jpg","jpeg","png","gif"],"formFieldUniqid":"avatar"},"hide":false,"id":"image47561","i":"5","pidx":"0"},{"name":"\\u624b\\u673a\\u53f7","type":"input","icon":"text-field","formItemFlag":true,"options":{"name":"phone","label":"\\u624b\\u673a\\u53f7","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"11","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @yongHuShouJiHaoFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","formFieldUniqid":"phone"},"hide":false,"id":"input57574","i":"7","pidx":"0"},{"name":"\\u804c\\u4f4dID","type":"input-number","icon":"number-field","formItemFlag":true,"options":{"name":"job","label":"\\u804c\\u4f4dID","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @yongHuZhiWeiIDFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","keyNameEnabled":false,"keyName":"","min":"-100000000000","max":"100000000000","precision":"0","step":"1","formFieldUniqid":"job"},"hide":false,"id":"inputnumber100269","i":"8","pidx":"0"},{"name":"\\u7528\\u6237\\u59d3\\u540d","type":"input","icon":"text-field","formItemFlag":true,"options":{"name":"name","label":"\\u7528\\u6237\\u59d3\\u540d","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"20","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @yongHuYongHuXingMingFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","formFieldUniqid":"name"},"hide":false,"id":"input67193","i":"6","pidx":"0"},{"name":"\\u7528\\u6237\\u5bc6\\u7801","type":"input","icon":"text-field","formItemFlag":true,"options":{"name":"password","label":"\\u7528\\u6237\\u5bc6\\u7801","labelAlign":"","type":"password","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":true,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"0","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","formFieldUniqid":"password"},"hide":false,"id":"input44770","i":"4","pidx":"0"},{"name":"\\u89d2\\u8272\\u6743\\u9650","type":"textarea","icon":"textarea-field","formItemFlag":true,"options":{"name":"roles","label":"\\u89d2\\u8272\\u6743\\u9650","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"0","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","rows":"3","formFieldUniqid":"roles"},"hide":false,"id":"textarea102750","i":"10","pidx":"0"},{"name":"\\u662f\\u5426\\u4e3a\\u8d85\\u7ea7\\u7ba1\\u7406\\u5458","type":"switch","icon":"switch-field","formItemFlag":true,"options":{"name":"is_admin","label":"\\u662f\\u5426\\u4e3a\\u8d85\\u7ea7\\u7ba1\\u7406\\u5458","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"0","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","switchWidth":"40","activeText":"\\u5f00\\u542f","inactiveText":"\\u5173\\u95ed","activeColor":"","inactiveColor":"","formFieldUniqid":"is_admin"},"hide":false,"id":"switch102045","i":"9","pidx":"0"},{"name":"\\u79fb\\u52a8\\u7aef\\u767b\\u5f55\\u72b6\\u6001","type":"switch","icon":"switch-field","formItemFlag":true,"options":{"name":"uni_online","label":"\\u79fb\\u52a8\\u7aef\\u767b\\u5f55\\u72b6\\u6001","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"0","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","switchWidth":"40","activeText":"\\u5f00\\u542f","inactiveText":"\\u5173\\u95ed","activeColor":"","inactiveColor":"","formFieldUniqid":"uni_online"},"hide":false,"id":"switch13185","i":"11","pidx":"0"},{"name":"\\u5907\\u6ce8","type":"textarea","icon":"textarea-field","formItemFlag":true,"options":{"name":"mark","label":"\\u5907\\u6ce8","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"0","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","rows":"3","formFieldUniqid":"mark"},"hide":false,"id":"textarea43072","i":"18","pidx":"0"},{"name":"\\u8fde\\u63a5\\u901a\\u9053ID","type":"input","icon":"text-field","formItemFlag":true,"options":{"name":"client_id","label":"\\u8fde\\u63a5\\u901a\\u9053ID","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"0","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","formFieldUniqid":"client_id"},"hide":false,"id":"input68685","i":"12","pidx":"0"}]'), '["account","avatar","phone","job","name","password","is_admin","roles","uni_online","mark","client_id"]', '{"modelName":"formData","refName":"vForm","rulesName":"rules","labelWidth":"111","labelPosition":"left","size":"small","labelAlign":"label-left-align","cssCode":"","customClass":[],"functions":"","layoutType":"PC","onFormCreated":"","onFormMounted":"","onFormDataChange":""}', 1, '2024-05-20 17:21:03', '2024-05-20 17:21:03', NULL);

-- 部门
INSERT INTO `eb_system_crud` (`id`, `table_name`, `table_name_en`, `cate_ids`, `info`, `crud_id`, `user_id`, `is_update_form`, `is_update_table`, `form_fields`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, '部门', 'frame', '', '', 0, '4', 0, 0, '', '2024-05-20 17:01:19', '2024-05-20 17:01:19', NULL);
SELECT @buMenCrudId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @buMenCrudId, '主键ID', 'id', 'input_number', 'int', 0, 0, '主键ID', '', 0, 0, 0, 0, 'frame664b115f310ad', '', '', 1, 1, 1, '2024-05-20 17:01:19', '2024-05-20 17:01:19', NULL),
(null, @buMenCrudId, '创建时间', 'created_at', 'date_time_picker', 'timestamp', 1, 0, '创建时间', 'level', 0, 0, 0, 0, 'frame664b115f310d5', '', '', 1, 1, 1, '2024-05-20 17:01:19', '2024-05-20 17:04:37', NULL),
(null, @buMenCrudId, '修改时间', 'updated_at', 'date_time_picker', 'timestamp', 1, 0, '修改时间', 'created_at', 0, 0, 0, 0, 'frame664b115f310da', '', '', 1, 1, 1, '2024-05-20 17:01:19', '2024-05-20 17:01:19', NULL),
(null, @buMenCrudId, '部门名称', 'name', 'input', 'varchar', 1, 1, '部门名称', 'owner_user_id', 0, 0, 1, 0, 'frame664b1183b236a', '[]', '[]', 1, 1, 1, '2024-05-20 17:01:55', '2024-05-20 17:01:55', NULL),
(null, @buMenCrudId, '父级ID', 'pid', 'input_select', 'int', 1, 1, '父级ID', 'name', 0, @buMenCrudId, 0, 0, 'frame664b11a3c7e68', '[\"id\",\"name\"]', '[]', 1, 1, 1, '2024-05-20 17:02:27', '2024-05-20 17:02:27', NULL),
(null, @buMenCrudId, '角色ID', 'role_id', 'input_number', 'int', 1, 1, '角色ID', 'pid', 0, 0, 0, 0, 'frame664b11be0b2f6', '[]', '[]', 1, 1, 1, '2024-05-20 17:02:54', '2024-05-20 17:02:54', NULL),
(null, @buMenCrudId, '路径', 'path', 'input', 'varchar', 1, 1, '路径', 'role_id', 0, 0, 0, 0, 'frame664b11d03a9fa', '[]', '[]', 1, 1, 1, '2024-05-20 17:03:12', '2024-05-20 17:03:12', NULL),
(null, @buMenCrudId, '部门介绍', 'introduce', 'input', 'varchar', 1, 1, '部门介绍', 'path', 0, 0, 0, 0, 'frame664b11dd09d48', '[]', '[]', 1, 1, 1, '2024-05-20 17:03:25', '2024-05-20 17:03:25', NULL),
(null, @buMenCrudId, '排序', 'sort', 'input_number', 'int', 1, 1, '排序', 'introduce', 0, 0, 0, 0, 'frame664b11f0612ab', '[]', '[]', 1, 1, 1, '2024-05-20 17:03:44', '2024-05-20 17:03:44', NULL),
(null, @buMenCrudId, '用户数量', 'user_count', 'input_number', 'int', 1, 1, '用户数量', 'sort', 0, 0, 0, 0, 'frame664b11fcd3d41', '[]', '[]', 1, 1, 1, '2024-05-20 17:03:56', '2024-05-20 17:03:56', NULL),
(null, @buMenCrudId, '单个部门总人数', 'user_single_count', 'input_number', 'int', 1, 1, '单个部门总人数', 'user_count', 0, 0, 0, 0, 'frame664b1207c7338', '[]', '[]', 1, 1, 1, '2024-05-20 17:04:07', '2024-05-20 17:04:07', NULL),
(null, @buMenCrudId, '是否显示', 'is_show', 'switch', 'tinyint', 1, 1, '是否显示', 'user_single_count', 0, 0, 0, 0, 'frame664b12175b208', '[]', '[]', 1, 1, 1, '2024-05-20 17:04:23', '2024-05-20 17:04:23', NULL),
(null, @buMenCrudId, '等级', 'level', 'input_number', 'int', 1, 1, '等级', 'is_show', 0, 0, 0, 0, 'frame664b122540ffb', '[]', '[]', 1, 1, 1, '2024-05-20 17:04:37', '2024-05-20 17:04:37', NULL);

-- #工资条
CREATE TABLE `eb_gongzitiaojiegou` (
`id` bigint unsigned NOT NULL AUTO_INCREMENT,
`user_id` int NOT NULL DEFAULT '0' COMMENT '创建用户id',
`update_user_id` int NOT NULL DEFAULT '0' COMMENT '修改用户id',
`owner_user_id` int NOT NULL DEFAULT '0' COMMENT '所属用户id',
`jibengongzi` decimal(10,2) DEFAULT NULL COMMENT '基本工资',
`jixiaogongzi` decimal(10,2) DEFAULT NULL COMMENT '绩效工资',
`gangweigongzi` decimal(10,2) DEFAULT NULL COMMENT '岗位工资',
`guanlijintie` decimal(10,2) DEFAULT NULL COMMENT '管理津贴',
`jinengbutie` decimal(10,2) DEFAULT NULL COMMENT '技能补贴',
`qitabutie` decimal(10,2) DEFAULT NULL COMMENT '其他补贴',
`yuangong` int DEFAULT NULL COMMENT '员工',
`tiaoxinbeizhu` text COLLATE utf8mb4_unicode_ci COMMENT '调薪备注',
`frame_id` int NOT NULL DEFAULT '0' COMMENT '部门ID',
`created_at` timestamp NULL DEFAULT NULL,
`updated_at` timestamp NULL DEFAULT NULL,
`deleted_at` timestamp NULL DEFAULT NULL,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `eb_gongzitiaojilu` (
`id` bigint unsigned NOT NULL AUTO_INCREMENT,
`user_id` int NOT NULL DEFAULT '0' COMMENT '创建用户id',
`update_user_id` int NOT NULL DEFAULT '0' COMMENT '修改用户id',
`owner_user_id` int NOT NULL DEFAULT '0' COMMENT '所属用户id',
`gongzitiaojiegou` int DEFAULT NULL COMMENT '工资条结构',
`jibengongzi` decimal(10,2) DEFAULT NULL COMMENT '基本工资',
`jixiaogongzi` decimal(10,2) DEFAULT NULL COMMENT '绩效工资',
`gangweigongzi` decimal(10,2) DEFAULT NULL COMMENT '岗位工资',
`guanlijintie` decimal(10,2) DEFAULT NULL COMMENT '管理津贴',
`jinengbutie` decimal(10,2) DEFAULT NULL COMMENT '技能补贴',
`qitabutie` decimal(10,2) DEFAULT NULL COMMENT '其他补贴',
`yuangong` int NOT NULL DEFAULT '0' COMMENT '员工',
`tiaoxinbeizhu` text COLLATE utf8mb4_unicode_ci COMMENT '调薪备注',
`frame_id` int NOT NULL DEFAULT '0' COMMENT '部门ID',
`created_at` timestamp NULL DEFAULT NULL,
`updated_at` timestamp NULL DEFAULT NULL,
`deleted_at` timestamp NULL DEFAULT NULL,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `eb_system_crud_cate` (`id`, `name`, `sort`, `created_at`, `updated_at`) VALUES (null, '工资条', 10, '2024-06-14 15:04:35', '2024-06-14 15:36:26');
SELECT @crudCateId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud` (`id`, `table_name`, `table_name_en`, `cate_ids`, `info`, `crud_id`, `user_id`, `is_update_form`, `is_update_table`, `form_fields`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, '工资条结构', 'gongzitiaojiegou',  CONCAT('/', @crudCateId, '/'), '', 0, '1', 0, 0, '[\"jibengongzi\",\"jixiaogongzi\",\"gangweigongzi\",\"guanlijintie\",\"jinengbutie\",\"qitabutie\",\"yuangong\",\"tiaoxinbeizhu\"]', '2024-06-14 15:04:56', '2024-06-15 11:21:36', NULL);
SELECT @gongZiJieGouCrudId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJieGouCrudId, '主键ID', 'id', 'input_number', 'int', 0, 1, '主键ID', '', 0, 0, 0, 0, 'gongzitiaojiegou666beb989e5c8', '', '', 1, 1, 1, '2024-06-14 15:04:56', '2024-06-15 11:21:36', NULL),
(null, @gongZiJieGouCrudId, '创建用户', 'user_id', 'input_select', 'int', 1, 0, '创建用户', 'id', 0, 0, 0, 0, 'gongzitiaojiegou666beb989e5cf', '', '', 1, 1, 1, '2024-06-14 15:04:56', '2024-06-15 11:21:36', NULL),
(null, @gongZiJieGouCrudId, '修改用户', 'update_user_id', 'input_select', 'int', 1, 0, '修改用户', 'user_id', 0, 0, 0, 0, 'gongzitiaojiegou666beb989e5d1', '', '', 1, 1, 1, '2024-06-14 15:04:56', '2024-06-15 11:21:36', NULL),
(null, @gongZiJieGouCrudId, '所属部门', 'frame_id', 'input_select', 'int', 1, 0, '所属部门', 'update_user_id', 0, 0, 0, 0, 'gongzitiaojiegou666beb989e5d4', '', '', 1, 1, 1, '2024-06-14 15:04:56', '2024-06-15 11:21:36', NULL),
(null, @gongZiJieGouCrudId, '所属用户', 'owner_user_id', 'input_select', 'int', 1, 0, '所属用户', 'frame_id', 0, 0, 0, 0, 'gongzitiaojiegou666beb989e5d7', '', '', 1, 1, 1, '2024-06-14 15:04:56', '2024-06-15 11:21:36', NULL);

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJieGouCrudId, '员工', 'yuangong', 'input_select', 'int', 0, 1, '员工', 'owner_user_id', 0, @yongHuCrudId, 0, 1, 'gongzitiaojiegou666bee52424e5', '[\"id\",\"name\"]', '[]', 1, 0, 1, '2024-06-14 15:16:34', '2024-06-15 11:21:36', NULL);
SELECT @gongZiJieGouYuanGongFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJieGouCrudId, '修改时间', 'updated_at', 'date_time_picker', 'timestamp', 1, 0, '修改时间', 'created_at', 0, 0, 0, 0, 'gongzitiaojiegou666beb989e5db', '', '', 1, 1, 1, '2024-06-14 15:04:56', '2024-06-15 11:21:36', NULL),
(null, @gongZiJieGouCrudId, '伪删除', 'deleted_at', 'date_time_picker', 'timestamp', 1, 0, '伪删除', 'updated_at', 0, 0, 0, 0, 'gongzitiaojiegou666beb989e5de', '', '', 1, 1, 1, '2024-06-14 15:04:56', '2024-06-15 11:21:36', NULL);

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJieGouCrudId, '基本工资', 'jibengongzi', 'input_float', 'decimal', 1, 1, '基本工资', 'owner_user_id', 0, 0, 0, 1, 'gongzitiaojiegou666bec56735cc', '[]', '{\"precision\":\"2\"}', 1, 1, 1, '2024-06-14 15:08:06', '2024-06-15 11:21:36', NULL);
SELECT @gongZiJieGouJiBenGongZiFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJieGouCrudId, '绩效工资', 'jixiaogongzi', 'input_float', 'decimal', 1, 1, '绩效工资', 'jibengongzi', 0, 0, 0, 1, 'gongzitiaojiegou666bec68eb19a', '[]', '{\"precision\":\"2\"}', 1, 1, 1, '2024-06-14 15:08:24', '2024-06-15 11:21:36', NULL);
SELECT @gongZiJieGouJiXiaoGongZiFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJieGouCrudId, '岗位工资', 'gangweigongzi', 'input_float', 'decimal', 1, 1, '岗位工资', 'jixiaogongzi', 0, 0, 0, 1, 'gongzitiaojiegou666bec78e31ab', '[]', '{\"precision\":\"2\"}', 1, 1, 1, '2024-06-14 15:08:40', '2024-06-15 11:21:36', NULL);
SELECT @gongZiJieGouGangWeiGongZiFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJieGouCrudId, '管理津贴', 'guanlijintie', 'input_float', 'decimal', 1, 1, '管理津贴', 'gangweigongzi', 0, 0, 0, 1, 'gongzitiaojiegou666bec82b2364', '[]', '{\"precision\":\"2\"}', 1, 1, 1, '2024-06-14 15:08:50', '2024-06-15 11:21:36', NULL);
SELECT @gongZiJieGouGuanLiJinTieFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJieGouCrudId, '技能补贴', 'jinengbutie', 'input_float', 'decimal', 1, 1, '技能补贴', 'guanlijintie', 0, 0, 0, 1, 'gongzitiaojiegou666bec8c45bb3', '[]', '{\"precision\":\"2\"}', 1, 1, 1, '2024-06-14 15:09:00', '2024-06-15 11:21:36', NULL);
SELECT @gongZiJieGouJiNengBuTieFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJieGouCrudId, '其他补贴', 'qitabutie', 'input_float', 'decimal', 1, 1, '其他补贴', 'jinengbutie', 0, 0, 0, 1, 'gongzitiaojiegou666bec958ed51', '[]', '{\"precision\":\"2\"}', 1, 1, 1, '2024-06-14 15:09:09', '2024-06-15 11:21:36', NULL);
SELECT @gongZiJieGouQiTaBuTieFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJieGouCrudId, '调薪备注', 'tiaoxinbeizhu', 'textarea', 'text', 1, 1, '调薪备注', 'yuangong', 0, 0, 0, 1, 'gongzitiaojiegou666d08bb7c461', '[]', '[]', 1, 1, 1, '2024-06-15 11:21:31', '2024-06-15 11:21:36', NULL);
SELECT @gongZiJieGouTiaoXinBeiZhuFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJieGouCrudId, '创建时间', 'created_at', 'date_time_picker', 'timestamp', 1, 1, '创建时间', 'tiaoxinbeizhu', 0, 0, 0, 0, 'gongzitiaojiegou666beb989e5d9', '', '', 1, 1, 1, '2024-06-14 15:04:56', '2024-06-15 11:21:36', NULL);

INSERT INTO `eb_system_crud_form` (`id`, `crud_id`, `version`, `options`, `fields`, `global_options`, `is_index`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJieGouCrudId, 1, CONCAT('[{"name":"\\u5458\\u5de5","type":"input-select","icon":"reference-field","formItemFlag":true,"options":{"name":"yuangong","label":"\\u5458\\u5de5","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @gongZiJieGouYuanGongFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","buttonText":"\\u9009\\u62e9","formFieldUniqid":"yuangong","isCityShow":""},"hide":false,"id":"inputselect57159","i":"12","pidx":"0"},{"name":"\\u57fa\\u672c\\u5de5\\u8d44","type":"input-float","icon":"number-field","formItemFlag":true,"options":{"name":"jibengongzi","label":"\\u57fa\\u672c\\u5de5\\u8d44","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @gongZiJieGouJiBenGongZiFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","keyNameEnabled":false,"keyName":"","min":"-999999999","max":"999999999","precision":"2","step":"1","formFieldUniqid":"jibengongzi","isCityShow":""},"hide":false,"id":"inputfloat79437","i":"6","pidx":"0"},{"name":"\\u7ee9\\u6548\\u5de5\\u8d44","type":"input-float","icon":"number-field","formItemFlag":true,"options":{"name":"jixiaogongzi","label":"\\u7ee9\\u6548\\u5de5\\u8d44","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @gongZiJieGouJiXiaoGongZiFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","keyNameEnabled":false,"keyName":"","min":"-999999999","max":"999999999","precision":"2","step":"1","formFieldUniqid":"jixiaogongzi","isCityShow":""},"hide":false,"id":"inputfloat18742","i":"7","pidx":"0"},{"name":"\\u5c97\\u4f4d\\u5de5\\u8d44","type":"input-float","icon":"number-field","formItemFlag":true,"options":{"name":"gangweigongzi","label":"\\u5c97\\u4f4d\\u5de5\\u8d44","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @gongZiJieGouGangWeiGongZiFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","keyNameEnabled":false,"keyName":"","min":"-999999999","max":"999999999","precision":"2","step":"1","formFieldUniqid":"gangweigongzi","isCityShow":""},"hide":false,"id":"inputfloat24128","i":"8","pidx":"0"},{"name":"\\u7ba1\\u7406\\u6d25\\u8d34","type":"input-float","icon":"number-field","formItemFlag":true,"options":{"name":"guanlijintie","label":"\\u7ba1\\u7406\\u6d25\\u8d34","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @gongZiJieGouGuanLiJinTieFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","keyNameEnabled":false,"keyName":"","min":"-999999999","max":"999999999","precision":"2","step":"1","formFieldUniqid":"guanlijintie","isCityShow":""},"hide":false,"id":"inputfloat104789","i":"9","pidx":"0"},{"name":"\\u6280\\u80fd\\u8865\\u8d34","type":"input-float","icon":"number-field","formItemFlag":true,"options":{"name":"jinengbutie","label":"\\u6280\\u80fd\\u8865\\u8d34","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @gongZiJieGouJiNengBuTieFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","keyNameEnabled":false,"keyName":"","min":"-999999999","max":"999999999","precision":"2","step":"1","formFieldUniqid":"jinengbutie","isCityShow":""},"hide":false,"id":"inputfloat58904","i":"10","pidx":"0"},{"name":"\\u5176\\u4ed6\\u8865\\u8d34","type":"input-float","icon":"number-field","formItemFlag":true,"options":{"name":"qitabutie","label":"\\u5176\\u4ed6\\u8865\\u8d34","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @gongZiJieGouQiTaBuTieFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","keyNameEnabled":false,"keyName":"","min":"-999999999","max":"999999999","precision":"2","step":"1","formFieldUniqid":"qitabutie","isCityShow":""},"hide":false,"id":"inputfloat85534","i":"11","pidx":"0"},{"name":"\\u8c03\\u85aa\\u5907\\u6ce8","type":"textarea","icon":"textarea-field","formItemFlag":true,"options":{"name":"tiaoxinbeizhu","label":"\\u8c03\\u85aa\\u5907\\u6ce8","labelAlign":"","type":"","defaultValue":"","placeholder":"","columnWidth":"200px","size":"","labelWidth":"","labelHidden":false,"readonly":false,"disabled":false,"hidden":false,"clearable":false,"showPassword":false,"required":false,"requiredHint":"","validation":"","validationHint":"","customClass":"","labelIconClass":"","labelIconPosition":"rear","labelTooltip":"","minLength":"300","maxLength":"300","showWordLimit":false,"prefixIcon":"","suffixIcon":"","appendButton":false,"appendButtonDisabled":false,"buttonIcon":"","dataDictId":"0","fieldId":"', @gongZiJieGouTiaoXinBeiZhuFieldId, '","onCreated":"","onMounted":"","onInput":"","onChange":"","onFocus":"","onBlur":"","onValidate":"","onAppendButtonClick":"","rows":"3","formFieldUniqid":"tiaoxinbeizhu","isCityShow":""},"hide":false,"id":"textarea4650","i":"13","pidx":"0"}]'), '["jibengongzi","jixiaogongzi","gangweigongzi","guanlijintie","jinengbutie","qitabutie","yuangong","tiaoxinbeizhu"]','{"modelName":"formData","refName":"vForm","rulesName":"rules","labelWidth":"80","labelPosition":"left","size":"small","labelAlign":"label-left-align","cssCode":"","customClass":[],"functions":"","layoutType":"PC","onFormCreated":"","onFormMounted":"","onFormDataChange":""}', 1, '2024-06-15 11:21:36', '2024-06-15 11:21:36', NULL);

INSERT INTO `eb_system_crud` (`id`, `table_name`, `table_name_en`, `cate_ids`, `info`, `crud_id`, `user_id`, `is_update_form`, `is_update_table`, `form_fields`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, '工资条记录', 'gongzitiaojilu', CONCAT('/', @crudCateId, '/'), '', 0, '1', 0, 0, '[\"gongzitiaojiegou\",\"jibengongzi\",\"gangweigongzi\",\"jixiaogongzi\",\"jinengbutie\",\"guanlijintie\",\"qitabutie\",\"yuangong\",\"tiaoxinbeizhu\"]', '2024-06-14 15:36:06', '2024-06-15 11:29:55', NULL);
SELECT @gongZiJiLuCrudId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJiLuCrudId, '主键ID', 'id', 'input_number', 'int', 0, 1, '主键ID', '', 0, 0, 0, 0, 'gongzitiaojilu666bf2e64f94d', '', '', 1, 1, 1, '2024-06-14 15:36:06', '2024-06-15 11:29:55', NULL),
(null, @gongZiJiLuCrudId, '创建用户', 'user_id', 'input_select', 'int', 1, 0, '创建用户', 'id', 0, 0, 0, 0, 'gongzitiaojilu666bf2e64f956', '', '', 1, 1, 1, '2024-06-14 15:36:06', '2024-06-15 11:29:55', NULL),
(null, @gongZiJiLuCrudId, '修改用户', 'update_user_id', 'input_select', 'int', 1, 0, '修改用户', 'user_id', 0, 0, 0, 0, 'gongzitiaojilu666bf2e64f95b', '', '', 1, 1, 1, '2024-06-14 15:36:06', '2024-06-15 11:29:55', NULL),
(null, @gongZiJiLuCrudId, '所属部门', 'frame_id', 'input_select', 'int', 1, 0, '所属部门', 'update_user_id', 0, 0, 0, 0, 'gongzitiaojilu666bf2e64f95f', '', '', 1, 1, 1, '2024-06-14 15:36:06', '2024-06-15 11:29:55', NULL),
(null, @gongZiJiLuCrudId, '所属用户', 'owner_user_id', 'input_select', 'int', 1, 0, '所属用户', 'frame_id', 0, 0, 0, 0, 'gongzitiaojilu666bf2e64f964', '', '', 1, 1, 1, '2024-06-14 15:36:06', '2024-06-15 11:29:55', NULL);

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJiLuCrudId, '员工', 'yuangong', 'input_select', 'int', 0, 1, '员工', 'qitabutie', 0, @yongHuCrudId, 0, 1, 'gongzitiaojilu666bf6f9821ed', '[\"id\",\"name\"]', '[]', 0, 0, 1, '2024-06-14 15:53:29', '2024-06-15 11:29:55', NULL);
SELECT @gongZiJiLuYuanGongFieldId := LAST_INSERT_ID();
INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJiLuCrudId, '修改时间', 'updated_at', 'date_time_picker', 'timestamp', 1, 0, '修改时间', 'created_at', 0, 0, 0, 0, 'gongzitiaojilu666bf2e64f96b', '', '', 1, 1, 1, '2024-06-14 15:36:06', '2024-06-15 11:29:55', NULL),
(null, @gongZiJiLuCrudId, '伪删除', 'deleted_at', 'date_time_picker', 'timestamp', 1, 0, '伪删除', 'updated_at', 0, 0, 0, 0, 'gongzitiaojilu666bf2e64f96e', '', '', 1, 1, 1, '2024-06-14 15:36:06', '2024-06-15 11:29:55', NULL);

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJiLuCrudId, '工资条结构', 'gongzitiaojiegou', 'input_select', 'int', 1, 0, '工资条结构', 'owner_user_id', 0, @gongZiJieGouCrudId, 0, 1, 'gongzitiaojilu666bf47eb9e2c', '[\"id\",\"owner_user_id\",\"yuangong\"]', '[]', 0, 0, 1, '2024-06-14 15:42:54', '2024-06-15 11:29:55', NULL);
SELECT @gongZiJiLuGongZiTiaoJieGoFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJiLuCrudId, '基本工资', 'jibengongzi', 'input_float', 'decimal', 1, 1, '基本工资', 'gongzitiaojiegou', 0, 0, 0, 1, 'gongzitiaojilu666bf4da6eb40', '[]', '{\"precision\":\"2\"}', 0, 0, 1, '2024-06-14 15:44:26', '2024-06-15 11:29:55', NULL);
SELECT @gongZiJiLuJiBenGongZiFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJiLuCrudId, '绩效工资', 'jixiaogongzi', 'input_float', 'decimal', 1, 1, '绩效工资', 'jibengongzi', 0, 0, 0, 1, 'gongzitiaojilu666bf4ebec42e', '[]', '{\"precision\":\"2\"}', 0, 0, 1, '2024-06-14 15:44:43', '2024-06-15 11:29:55', NULL);
SELECT @gongZiJiLuJiXiaoGongZiFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJiLuCrudId, '岗位工资', 'gangweigongzi', 'input_float', 'decimal', 1, 1, '岗位工资', 'jixiaogongzi', 0, 0, 0, 1, 'gongzitiaojilu666bf4f64d6ab', '[]', '{\"precision\":\"2\"}', 0, 0, 1, '2024-06-14 15:44:54', '2024-06-15 11:29:55', NULL);
SELECT @gongZiJiLuGangWeiGongZiFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJiLuCrudId, '管理津贴', 'guanlijintie', 'input_float', 'decimal', 1, 1, '管理津贴', 'gangweigongzi', 0, 0, 0, 1, 'gongzitiaojilu666bf5025fe24', '[]', '{\"precision\":\"2\"}', 0, 0, 1, '2024-06-14 15:45:06', '2024-06-15 11:29:55', NULL);
SELECT @gongZiJiLuGuanLiJinTieFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJiLuCrudId, '技能补贴', 'jinengbutie', 'input_float', 'decimal', 1, 1, '技能补贴', 'guanlijintie', 0, 0, 0, 1, 'gongzitiaojilu666bf50ccc1c1', '[]', '{\"precision\":\"2\"}', 0, 0, 1, '2024-06-14 15:45:16', '2024-06-15 11:29:55', NULL);
SELECT @gongZiJiLuJiNengBuTieFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJiLuCrudId, '其他补贴', 'qitabutie', 'input_float', 'decimal', 1, 1, '其他补贴', 'jinengbutie', 0, 0, 0, 1, 'gongzitiaojilu666bf5169a11e', '[]', '{\"precision\":\"2\"}', 0, 0, 1, '2024-06-14 15:45:26', '2024-06-15 11:29:55', NULL);
SELECT @gongZiJiLuQiTaBuTieFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJiLuCrudId, '调薪备注', 'tiaoxinbeizhu', 'textarea', 'text', 1, 1, '调薪备注', 'yuangong', 0, 0, 0, 1, 'gongzitiaojilu666d0aae746f7', '[]', '[]', 0, 0, 1, '2024-06-15 11:29:50', '2024-06-15 11:29:55', NULL);
SELECT @gongZiJiLuTiaoXinBeiZhuFieldId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @gongZiJiLuCrudId, '创建时间', 'created_at', 'date_time_picker', 'timestamp', 1, 1, '创建时间', 'tiaoxinbeizhu', 0, 0, 0, 0, 'gongzitiaojilu666bf2e64f968', '', '', 1, 1, 1, '2024-06-14 15:36:06', '2024-06-15 11:29:55', NULL);

INSERT INTO `eb_system_crud_event` (`id`, `crud_id`, `name`, `event`, `action`, `sort`, `target_crud_id`, `crud_approve_id`, `send_type`, `send_user`, `notify_type`, `additional_search`, `template`, `field_options`, `options`, `created_at`, `updated_at`, `deleted_at`, `status`, `additional_search_boolean`, `aggregate_target_search_boolean`, `aggregate_data_search_boolean`, `aggregate_data_search`, `timer`, `aggregate_target_search`, `aggregate_field_rule`, `aggregate_data_field`) VALUES
(null, @gongZiJieGouCrudId, '数据记录', 'auto_create', '[\"create\",\"update\"]', 999, @gongZiJiLuCrudId, 0, 0, '[]', '[]', '[]', '', '[{\"form_field_uniqid\":\"gongzitiaojilu.qitabutie\",\"operator\":\"field_value\",\"to_form_field_uniqid\":\"qitabutie\"},{\"form_field_uniqid\":\"gongzitiaojilu.jinengbutie\",\"operator\":\"field_value\",\"to_form_field_uniqid\":\"jinengbutie\"},{\"form_field_uniqid\":\"gongzitiaojilu.guanlijintie\",\"operator\":\"field_value\",\"to_form_field_uniqid\":\"guanlijintie\"},{\"form_field_uniqid\":\"gongzitiaojilu.gangweigongzi\",\"operator\":\"field_value\",\"to_form_field_uniqid\":\"gangweigongzi\"},{\"form_field_uniqid\":\"gongzitiaojilu.jixiaogongzi\",\"operator\":\"field_value\",\"to_form_field_uniqid\":\"jixiaogongzi\"},{\"form_field_uniqid\":\"gongzitiaojilu.jibengongzi\",\"operator\":\"field_value\",\"to_form_field_uniqid\":\"jibengongzi\"},{\"form_field_uniqid\":\"gongzitiaojilu.tiaoxinbeizhu\",\"operator\":\"field_value\",\"to_form_field_uniqid\":\"tiaoxinbeizhu\"},{\"form_field_uniqid\":\"gongzitiaojilu.yuangong\",\"operator\":\"field_value\",\"to_form_field_uniqid\":\"yuangong\"}]', '[]', '2024-06-14 15:18:48', '2024-06-15 11:30:41', NULL, 1, 0, 0, 0, '[]', 0, '[]', '[]', '[]');

UPDATE `eb_system_menus` SET `menu_path` = '/customer/whole/index', `component` = 'customer/whole/index' WHERE `unique_auth` = 'menus66b96db6a0161';
UPDATE `eb_system_menus` SET `menu_path` = '/setting/enterprise/info/basic', `component` = 'setting/enterprise/info/basic' WHERE `unique_auth` = 'menus667d4ba69f914' AND `level` = 1;
SELECT `id` INTO @entMenuId FROM `eb_system_menus` WHERE `unique_auth` = 'menus667d4ba69f914' AND `level` = 1;
DELETE FROM `eb_system_menus` WHERE `pid` = @entMenuId AND `level` = 2;

SELECT `id` INTO @kaifaMenuId FROM `eb_system_menus` WHERE `unique_auth` = 'menus65e51ff04a5d5';
INSERT INTO `eb_system_menus` (`id`, `pid`, `icon`, `menu_name`, `api`, `methods`, `unique_auth`, `menu_path`, `menu_type`, `crud_id`, `uni_path`, `uni_img`, `position`, `path`, `component`, `level`, `other`, `sort`, `entid`, `type`, `is_show`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @kaifaMenuId, 'iconbangong-gongzuotai-cebian', '图表列表', '', '', 'menus667d4d23de29f', '/dashboard/list', 0, 0, '', '', 0, '614', 'system/dashboard-design/list/index', 1, '', 0, 0, 'M', 1, 1, '2024-06-27 19:29:39', '2024-06-27 19:29:39', NULL),
(null, @kaifaMenuId, 'iconbangong-yunwenjian-cebian', '接口管理', '', '', 'menus66a1b181e52fa', '/develop/dataManagement', 0, 0, '', '', 0, '622', 'develop/dataManagement/index', 1, '', 0, 0, 'M', 1, 1, '2024-07-25 01:56:25', '2024-07-25 01:59:29', NULL);


SELECT `id` INTO @grbgCid FROM `eb_category` WHERE `cate_name` = '个人办公';
SELECT `id` INTO @khglCid FROM `eb_category` WHERE `cate_name` = '客户管理';
SELECT `id` INTO @bggjCid FROM `eb_category` WHERE `cate_name` = '办公工具';
INSERT INTO `eb_system_quick` (`id`, `name`, `cid`, `pc_url`, `uni_url`, `image`, `sort`, `types`, `pc_show`, `uni_show`, `status`, `created_at`, `updated_at`) VALUES
(null, '业绩统计', @khglCid, '/pages/customer/list/statistics', '/pages/customer/list/statistics', 'https://resources-demo.oss-cn-beijing.aliyuncs.com/attach/2024/08/66a43202408131014449948.png', 1, 0, 0, 1, 1, '2023-08-14 08:04:39', '2024-08-13 10:16:26'),
(null, '速记', @bggjCid, '/pages/users/memorandum/create', '/pages/users/memorandum/create', 'https://crmebent.oss-cn-hangzhou.aliyuncs.com/files/%E8%AE%B0%E4%BA%8B%E6%9C%AC%402x.png', 1, 0, 0, 1, 1, '2023-08-31 09:47:02', '2023-10-18 16:51:37'),
(null, '工作汇报', @grbgCid, '/user/daily', '/pages/users/report/index', 'https://crmebent.oss-cn-hangzhou.aliyuncs.com/files/%E5%B7%A5%E4%BD%9C%E6%B1%87%E6%8A%A5%402x.png', 1, 0, 1, 1, 1, '2023-08-31 09:48:11', '2024-08-07 15:18:25'),
(null, '考勤打卡', @grbgCid, '123', '/pages/attendance/index', 'https://crmebent.oss-cn-hangzhou.aliyuncs.com/files/%E5%91%98%E5%B7%A5%E6%A1%A3%E6%A1%88%402x(1).png', 1, 0, 0, 1, 1, '2023-09-06 01:58:36', '2023-10-18 16:50:42'),
(null, '公司介绍', @grbgCid, '/user/training/profile', '', 'https://resources-demo.oss-cn-beijing.aliyuncs.com/attach/2024/08/d02b1202408131011057651.png', 2, 0, 1, 0, 1, '2024-07-09 15:51:06', '2024-08-13 10:18:27'),
(null, '云盘', @bggjCid, '/user/cloudfile/index', '', 'https://resources-demo.oss-cn-beijing.aliyuncs.com/attach/2024/08/8bbcd202408131015354637.png', 1, 0, 1, 0, 1, '2024-08-08 09:10:57', '2024-08-13 10:19:49'),
(null, '合同收支', @khglCid, '/customer/whole/index', '', 'https://resources-demo.oss-cn-beijing.aliyuncs.com/attach/2024/08/b7177202408131008595865.png', 1, 0, 1, 0, 1, '2024-08-08 09:14:34', '2024-08-13 10:17:10'),
(null, '项目管理', @bggjCid, '/program/programList/index', '', 'https://resources-demo.oss-cn-beijing.aliyuncs.com/attach/2024/08/e3f76202408131014394764.png', 1, 0, 1, 0, 1, '2024-08-08 09:19:04', '2024-08-13 10:19:00'),
(null, '我的任务', @bggjCid, '/program/programTask/index', '', 'https://resources-demo.oss-cn-beijing.aliyuncs.com/attach/2024/08/fe99d20240813100931581.png', 1, 0, 1, 0, 1, '2024-08-08 09:20:07', '2024-08-13 10:19:36');
ALTER TABLE `eb_contract` ADD `contract_cate` VARCHAR(32) NOT NULL DEFAULT '' COMMENT '合同分类copy' AFTER `contract_category`;

INSERT INTO `eb_system_crud` (`id`, `table_name`, `table_name_en`, `cate_ids`, `info`, `crud_id`, `user_id`, `is_update_form`, `is_update_table`, `form_fields`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, '订单', 'biaozhunbandingdan', '', '', 0, '55', 0, 0, '[\"dingdanbianhao\",\"shifujine\"]', '2024-08-24 16:12:35', '2024-08-24 16:13:06', NULL);
SELECT @biaozhunbandingdanCrudId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `is_uniqid`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @biaozhunbandingdanCrudId, '主键ID', 'id', 'input_number', 'int', 0, 0, '主键ID', '', 0, 0, 0, 0, 'biaozhunbandingdan66c995f301b4b', '', '', 1, 1, 1, 0, '2024-08-24 16:12:35', '2024-08-24 16:13:06', NULL),
(null, @biaozhunbandingdanCrudId, '创建用户', 'user_id', 'input_select', 'int', 1, 0, '创建用户', 'id', 0, 144, 0, 0, 'biaozhunbandingdan66c995f301f7c', '', '', 1, 1, 1, 0, '2024-08-24 16:12:35', '2024-08-24 16:13:06', NULL),
(null, @biaozhunbandingdanCrudId, '修改用户', 'update_user_id', 'input_select', 'int', 1, 0, '修改用户', 'user_id', 0, 144, 0, 0, 'biaozhunbandingdan66c995f302320', '', '', 1, 1, 1, 0, '2024-08-24 16:12:35', '2024-08-24 16:13:06', NULL),
(null, @biaozhunbandingdanCrudId, '所属部门', 'frame_id', 'input_select', 'int', 1, 0, '所属部门', 'update_user_id', 0, 145, 0, 0, 'biaozhunbandingdan66c995f3026d9', '', '', 1, 1, 1, 0, '2024-08-24 16:12:35', '2024-08-24 16:13:06', NULL),
(null, @biaozhunbandingdanCrudId, '所属用户', 'owner_user_id', 'input_select', 'int', 1, 0, '所属用户', 'frame_id', 0, 144, 0, 0, 'biaozhunbandingdan66c995f302a73', '', '', 1, 1, 1, 0, '2024-08-24 16:12:35', '2024-08-24 16:13:06', NULL),
(null, @biaozhunbandingdanCrudId, '创建时间', 'created_at', 'date_time_picker', 'timestamp', 1, 0, '创建时间', 'shifujine', 0, 0, 0, 0, 'biaozhunbandingdan66c995f302a81', '', '', 1, 1, 1, 0, '2024-08-24 16:12:35', '2024-08-24 16:13:06', NULL),
(null, @biaozhunbandingdanCrudId, '修改时间', 'updated_at', 'date_time_picker', 'timestamp', 1, 0, '修改时间', 'created_at', 0, 0, 0, 0, 'biaozhunbandingdan66c995f302a89', '', '', 1, 1, 1, 0, '2024-08-24 16:12:35', '2024-08-24 16:13:06', NULL),
(null, @biaozhunbandingdanCrudId, '伪删除', 'deleted_at', 'date_time_picker', 'timestamp', 1, 0, '伪删除', 'updated_at', 0, 0, 0, 0, 'biaozhunbandingdan66c995f302a8f', '', '', 1, 1, 1, 0, '2024-08-24 16:12:35', '2024-08-24 16:13:06', NULL),
(null, @biaozhunbandingdanCrudId, '订单编号', 'dingdanbianhao', 'input', 'varchar', 1, 1, '订单编号', 'owner_user_id', 0, 0, 1, 1, 'biaozhunbandingdan66c995ff52d0b', '[]', '[]', 1, 1, 0, 1, '2024-08-24 16:12:47', '2024-08-24 16:13:06', NULL),
(null, @biaozhunbandingdanCrudId, '实付金额', 'shifujine', 'input_price', 'decimal', 1, 1, '实付金额', 'dingdanbianhao', 0, 0, 0, 1, 'biaozhunbandingdan66c9960b877ac', '[]', '[]', 1, 1, 0, 0, '2024-08-24 16:12:59', '2024-08-24 16:13:06', NULL);

INSERT INTO `eb_system_crud_form` (`id`, `crud_id`, `version`, `options`, `fields`, `global_options`, `is_index`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @biaozhunbandingdanCrudId, 1, '[{\"name\":\"订单编号\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"dingdanbianhao\",\"label\":\"订单编号\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":null,\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":null,\"labelIconPosition\":\"rear\",\"labelTooltip\":null,\"minLength\":300,\"maxLength\":300,\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":0,\"fieldId\":0,\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"dingdanbianhao\"},\"hide\":false,\"id\":\"input16921\",\"i\":6,\"pidx\":0},{\"name\":\"实付金额\",\"type\":\"input-price\",\"icon\":\"number-field\",\"formItemFlag\":true,\"options\":{\"name\":\"shifujine\",\"label\":\"实付金额\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":null,\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":null,\"labelIconPosition\":\"rear\",\"labelTooltip\":null,\"minLength\":300,\"maxLength\":300,\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":0,\"fieldId\":2085,\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"keyNameEnabled\":false,\"keyName\":\"\",\"min\":-100000000000,\"max\":100000000000,\"precision\":0,\"step\":1,\"formFieldUniqid\":\"shifujine\"},\"hide\":false,\"id\":\"inputprice111732\",\"i\":7,\"pidx\":0}]', '[\"dingdanbianhao\",\"shifujine\"]', '{\"modelName\":\"formData\",\"refName\":\"vForm\",\"rulesName\":\"rules\",\"labelWidth\":80,\"labelPosition\":\"left\",\"size\":\"small\",\"labelAlign\":\"label-left-align\",\"cssCode\":\"\",\"customClass\":[],\"functions\":\"\",\"layoutType\":\"PC\",\"onFormCreated\":\"\",\"onFormMounted\":\"\",\"onFormDataChange\":\"\"}', 1, '2024-08-24 16:13:06', '2024-08-24 16:13:06', NULL);

INSERT INTO `eb_system_crud` (`id`, `table_name`, `table_name_en`, `cate_ids`, `info`, `crud_id`, `user_id`, `is_update_form`, `is_update_table`, `form_fields`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, '财务分类', 'bill_category', '', '', 0, '4', 0, 0, '', '2024-09-09 16:04:50', '2024-09-09 16:04:50', NULL);
SELECT @billCategoryCrudId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `is_uniqid`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @billCategoryCrudId, '自增id', 'id', 'input', 'varchar', 0, 1, '自增id', 'frame_id', 0, 0, 0, 0, 'bill_category66deac48ca422', '[]', '[]', 1, 1, 1, 0, '2024-09-09 16:05:28', '2024-09-09 16:05:28', NULL),
(null, @billCategoryCrudId, '分类名称', 'name', 'input', 'varchar', 0, 1, '分类名称', 'id', 0, 0, 1, 0, 'bill_category66deaccc29190', '[]', '[]', 1, 1, 1, 0, '2024-09-09 16:07:40', '2024-09-09 16:07:40', NULL),
(null, @billCategoryCrudId, '排序', 'sort', 'input_number', 'int', 0, 1, '排序', 'name', 0, 0, 0, 0, 'bill_category66deace6c68b6', '[]', '[]', 1, 1, 1, 0, '2024-09-09 16:08:06', '2024-09-09 16:08:06', NULL),
(null, @billCategoryCrudId, '类型', 'types', 'radio', 'int', 1, 1, '类型', 'sort', 43, 0, 0, 0, 'bill_category66dfad81df49e', '[]', '[]', 1, 1, 1, 0, '2024-09-10 10:22:57', '2024-09-10 10:22:57', NULL);

INSERT INTO `eb_system_crud` (`id`, `table_name`, `table_name_en`, `cate_ids`, `info`, `crud_id`, `user_id`, `is_update_form`, `is_update_table`, `form_fields`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, '财务', 'bill_list', '', '财务列表', 0, '4', 0, 0, '[\"uid\",\"cate_id\",\"num\",\"edit_time\",\"types\",\"type_id\",\"pay_type\",\"mark\",\"link_cate\"]', '2024-09-09 15:57:14', '2024-09-09 17:19:55', NULL);
SELECT @billListCrudId := LAST_INSERT_ID();

INSERT INTO `eb_system_crud_field` (`id`, `crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`, `is_uniqid`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @billListCrudId, '自增id', 'id', 'input_number', 'int', 0, 1, '自增id', 'frame_id', 0, 0, 0, 0, 'bill_list66deaada95fd0', '[]', '[]', 1, 1, 1, 0, '2024-09-09 15:59:22', '2024-09-09 17:19:55', NULL),
(null, @billListCrudId, '财务流水分类', 'cate_id', 'input_select', 'int', 0, 1, '财务流水分类', 'uid', 0, @billCategoryCrudId, 0, 1, 'bill_list66deadbc8d0f5', '[\"id\",\"name\",\"types\",\"sort\"]', '[]', 1, 1, 1, 0, '2024-09-09 16:11:40', '2024-09-09 17:19:55', NULL),
(null, @billListCrudId, '变动金额', 'num', 'input_price', 'decimal', 0, 1, '变动金额', 'cate_id', 0, 0, 0, 1, 'bill_list66deadd7c9292', '[]', '[]', 1, 1, 1, 0, '2024-09-09 16:12:07', '2024-09-09 17:19:55', NULL),
(null, @billListCrudId, '变动时间', 'edit_time', 'date_time_picker', 'timestamp', 1, 1, '变动时间', 'num', 0, 0, 0, 1, 'bill_list66deadf339f47', '[]', '[]', 1, 1, 1, 0, '2024-09-09 16:12:35', '2024-09-09 17:19:55', NULL),
(null, @billListCrudId, '变动类型', 'types', 'radio', 'int', 1, 1, '变动类型', 'edit_time', 43, 0, 0, 1, 'bill_list66deb09f67633', '[]', '[]', 1, 1, 1, 0, '2024-09-09 16:23:59', '2024-09-09 17:19:55', NULL),
(null, @billListCrudId, '支付方式', 'type_id', 'radio', 'int', 1, 1, '支付方式', 'types', 34, 0, 0, 1, 'bill_list66deb0b9dd838', '[]', '[]', 1, 1, 1, 0, '2024-09-09 16:24:25', '2024-09-09 17:19:55', NULL),
(null, @billListCrudId, '支付方式名称', 'pay_type', 'input', 'varchar', 1, 1, '支付方式名称', 'type_id', 0, 0, 1, 1, 'bill_list66deb0dba5564', '[]', '[]', 1, 1, 1, 0, '2024-09-09 16:24:59', '2024-09-09 17:19:55', NULL),
(null, @billListCrudId, '备注', 'mark', 'input', 'varchar', 1, 1, '备注', 'pay_type', 0, 0, 0, 1, 'bill_list66deb0e8484ae', '[]', '[]', 1, 1, 1, 0, '2024-09-09 16:25:12', '2024-09-09 17:19:55', NULL),
(null, @billListCrudId, '用户id', 'user_id', 'input_select', 'int', 1, 1, '用户id', 'mark', 0, @yongHuCrudId, 0, 0, 'bill_list66dfae357cf35', '[\"id\",\"password\",\"name\",\"account\",\"phone\",\"avatar\"]', '[]', 1, 1, 0, 0, '2024-09-10 10:25:57', '2024-09-10 10:25:57', NULL),
(null, @billListCrudId, '订单id', 'order_id', 'input_select', 'int', 0, 1, '订单id', 'link_id', 0, @biaozhunbandingdanCrudId, 0, 0, 'bill_list66e00c40e2ae2', '[\"id\",\"dingdanbianhao\"]', '[]', 1, 1, 0, 0, '2024-09-10 17:07:12', '2024-09-10 17:07:12', NULL);

INSERT INTO `eb_system_crud_form` (`id`, `crud_id`, `version`, `options`, `fields`, `global_options`, `is_index`, `created_at`, `updated_at`, `deleted_at`) VALUES
(null, @billListCrudId, 1, '[{\"name\":\"\\u7528\\u6237id\",\"type\":\"input-select\",\"icon\":\"reference-field\",\"formItemFlag\":true,\"options\":{\"name\":\"uid\",\"label\":\"\\u7528\\u6237id\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":null,\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":null,\"labelIconPosition\":\"rear\",\"labelTooltip\":null,\"minLength\":300,\"maxLength\":300,\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":0,\"fieldId\":2103,\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"buttonText\":\"\\u9009\\u62e9\",\"formFieldUniqid\":\"uid\"},\"hide\":false,\"id\":\"inputselect64424\",\"i\":0,\"pidx\":0},{\"name\":\"\\u8d22\\u52a1\\u6d41\\u6c34\\u5206\\u7c7b\",\"type\":\"input-select\",\"icon\":\"reference-field\",\"formItemFlag\":true,\"options\":{\"name\":\"cate_id\",\"label\":\"\\u8d22\\u52a1\\u6d41\\u6c34\\u5206\\u7c7b\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":null,\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":null,\"labelIconPosition\":\"rear\",\"labelTooltip\":null,\"minLength\":300,\"maxLength\":300,\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":0,\"fieldId\":2108,\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"buttonText\":\"\\u9009\\u62e9\",\"formFieldUniqid\":\"cate_id\"},\"hide\":false,\"id\":\"inputselect21517\",\"i\":1,\"pidx\":0},{\"name\":\"\\u53d8\\u52a8\\u91d1\\u989d\",\"type\":\"input-price\",\"icon\":\"number-field\",\"formItemFlag\":true,\"options\":{\"name\":\"num\",\"label\":\"\\u53d8\\u52a8\\u91d1\\u989d\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":null,\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":null,\"labelIconPosition\":\"rear\",\"labelTooltip\":null,\"minLength\":300,\"maxLength\":300,\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":0,\"fieldId\":2109,\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"keyNameEnabled\":false,\"keyName\":\"\",\"min\":-100000000000,\"max\":100000000000,\"precision\":0,\"step\":1,\"formFieldUniqid\":\"num\"},\"hide\":false,\"id\":\"inputprice114840\",\"i\":2,\"pidx\":0},{\"name\":\"\\u53d8\\u52a8\\u65f6\\u95f4\",\"type\":\"date-time-picker\",\"icon\":\"date-range-field\",\"formItemFlag\":true,\"options\":{\"name\":\"edit_time\",\"label\":\"\\u53d8\\u52a8\\u65f6\\u95f4\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":null,\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":null,\"labelIconPosition\":\"rear\",\"labelTooltip\":null,\"minLength\":300,\"maxLength\":300,\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":0,\"fieldId\":2110,\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"editable\":false,\"format\":\"yyyy-MM-dd HH:mm:ss\",\"valueFormat\":\"yyyy-MM-dd HH:mm:ss\",\"formFieldUniqid\":\"edit_time\"},\"hide\":false,\"id\":\"datetimepicker80464\",\"i\":3,\"pidx\":0},{\"name\":\"\\u53d8\\u52a8\\u7c7b\\u578b\",\"type\":\"radio\",\"icon\":\"radio-field\",\"formItemFlag\":true,\"options\":{\"name\":\"types\",\"label\":\"\\u53d8\\u52a8\\u7c7b\\u578b\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":null,\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":null,\"labelIconPosition\":\"rear\",\"labelTooltip\":null,\"minLength\":300,\"maxLength\":300,\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":43,\"fieldId\":2111,\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"displayStyle\":\"inline\",\"buttonStyle\":false,\"border\":false,\"optionItems\":[{\"id\":4364,\"name\":\"\\u652f\\u51fa\",\"value\":\"0\",\"type_id\":43,\"pid\":\"\",\"type_name\":\"bill_type\",\"sort\":0,\"status\":1,\"is_default\":0,\"level\":1,\"mark\":\"\",\"created_at\":\"2024-09-09 16:22:33\",\"updated_at\":\"2024-09-09 16:22:33\",\"checkbox\":false},{\"id\":4365,\"name\":\"\\u6536\\u5165\",\"value\":\"1\",\"type_id\":43,\"pid\":\"\",\"type_name\":\"bill_type\",\"sort\":0,\"status\":1,\"is_default\":0,\"level\":1,\"mark\":\"\",\"created_at\":\"2024-09-09 16:23:12\",\"updated_at\":\"2024-09-09 16:23:12\",\"checkbox\":false}],\"formFieldUniqid\":\"types\"},\"hide\":false,\"id\":\"radio74256\",\"i\":4,\"pidx\":0},{\"name\":\"\\u652f\\u4ed8\\u65b9\\u5f0f\",\"type\":\"radio\",\"icon\":\"radio-field\",\"formItemFlag\":true,\"options\":{\"name\":\"type_id\",\"label\":\"\\u652f\\u4ed8\\u65b9\\u5f0f\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":null,\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":null,\"labelIconPosition\":\"rear\",\"labelTooltip\":null,\"minLength\":300,\"maxLength\":300,\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":34,\"fieldId\":2112,\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"displayStyle\":\"inline\",\"buttonStyle\":false,\"border\":false,\"optionItems\":[{\"id\":4292,\"name\":\"\\u5bf9\\u516c\\u8f6c\\u8d26\",\"value\":\"1\",\"type_id\":34,\"pid\":\"\",\"type_name\":\"zhifufangshi\",\"sort\":0,\"status\":1,\"is_default\":0,\"level\":1,\"mark\":\"\",\"created_at\":\"2024-04-23 11:57:09\",\"updated_at\":\"2024-04-23 11:57:09\",\"checkbox\":false},{\"id\":4293,\"name\":\"\\u4f59\\u989d1\",\"value\":\"2\",\"type_id\":34,\"pid\":\"\",\"type_name\":\"zhifufangshi\",\"sort\":0,\"status\":1,\"is_default\":0,\"level\":1,\"mark\":\"\",\"created_at\":\"2024-04-23 11:57:17\",\"updated_at\":\"2024-06-25 12:51:55\",\"checkbox\":false},{\"id\":4294,\"name\":\"\\u5fae\\u4fe1\",\"value\":\"3\",\"type_id\":34,\"pid\":\"\",\"type_name\":\"zhifufangshi\",\"sort\":0,\"status\":1,\"is_default\":0,\"level\":1,\"mark\":\"\",\"created_at\":\"2024-04-23 11:57:22\",\"updated_at\":\"2024-04-23 11:57:22\",\"checkbox\":false},{\"id\":4295,\"name\":\"\\u652f\\u4ed8\\u5b9d\",\"value\":\"4\",\"type_id\":34,\"pid\":\"\",\"type_name\":\"zhifufangshi\",\"sort\":0,\"status\":1,\"is_default\":0,\"level\":1,\"mark\":\"\",\"created_at\":\"2024-04-23 11:57:27\",\"updated_at\":\"2024-04-23 11:57:27\",\"checkbox\":false}],\"formFieldUniqid\":\"type_id\"},\"hide\":false,\"id\":\"radio109877\",\"i\":5,\"pidx\":0},{\"name\":\"\\u5907\\u6ce8\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"mark\",\"label\":\"\\u5907\\u6ce8\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":null,\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":null,\"labelIconPosition\":\"rear\",\"labelTooltip\":null,\"minLength\":300,\"maxLength\":300,\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":0,\"fieldId\":2114,\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"mark\"},\"hide\":false,\"id\":\"input29613\",\"i\":7,\"pidx\":0},{\"name\":\"\\u5173\\u8054\\u7c7b\\u578b\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"link_cate\",\"label\":\"\\u5173\\u8054\\u7c7b\\u578b\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":null,\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":null,\"labelIconPosition\":\"rear\",\"labelTooltip\":null,\"minLength\":300,\"maxLength\":300,\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":0,\"fieldId\":2115,\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"link_cate\"},\"hide\":false,\"id\":\"input55503\",\"i\":8,\"pidx\":0},{\"name\":\"\\u652f\\u4ed8\\u65b9\\u5f0f\\u540d\\u79f0\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"pay_type\",\"label\":\"\\u652f\\u4ed8\\u65b9\\u5f0f\\u540d\\u79f0\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":null,\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":null,\"labelIconPosition\":\"rear\",\"labelTooltip\":null,\"minLength\":300,\"maxLength\":300,\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":0,\"fieldId\":2113,\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"pay_type\"},\"hide\":false,\"id\":\"input20702\",\"i\":6,\"pidx\":0}]', '[\"uid\",\"cate_id\",\"num\",\"edit_time\",\"types\",\"type_id\",\"pay_type\",\"mark\",\"link_cate\"]', '{\"modelName\":\"formData\",\"refName\":\"vForm\",\"rulesName\":\"rules\",\"labelWidth\":80,\"labelPosition\":\"left\",\"size\":\"small\",\"labelAlign\":\"label-left-align\",\"cssCode\":\"\",\"customClass\":[],\"functions\":\"\",\"layoutType\":\"PC\",\"onFormCreated\":\"\",\"onFormMounted\":\"\",\"onFormDataChange\":\"\"}', 1, '2024-09-09 17:19:55', '2024-09-09 17:19:55', NULL);
