<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('attendance_wifi', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('entid')->default(0)->comment('企业ID');
            $table->unsignedInteger('group_id')->default(0)->comment('考勤组ID');
            $table->string('name',64)->default('')->comment('wifi名称');
            $table->string('mac', 64)->default('')->index()->comment('wifi地址');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('attendance_wifi');
    }
};
