<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Observers;

use App\Http\Model\Admin\Admin;
use App\Http\Model\Admin\AdminInfo;
use App\Http\Model\User\User;
use Illuminate\Contracts\Container\BindingResolutionException;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;
use Psr\SimpleCache\InvalidArgumentException;
use Webpatser\Uuid\Uuid;

/**
 * 企业用户观察者.
 */
class UserObserver
{
    /**
     * Handle the Admin "creating" event.
     * @throws \Exception
     */
    public function creating(User $model)
    {
        $birthday        = birthday_from_id_card($model->card_id);
        $model->birthday = substr($birthday, 0, 4) . '-' . substr($birthday, 4, 2) . '-' . substr($birthday, 6, 2);
        $model->age      = birthday_to_age($model->birthday);
        if (!$model->getKey()) {
            $model->{$model->getKeyName()} = str_replace('-', '', (string)Uuid::generate(4));
        }
    }

    /**
     * Handle the Admin "created" event.
     * @throws BindingResolutionException
     * @throws ContainerExceptionInterface
     * @throws NotFoundExceptionInterface
     * @throws InvalidArgumentException
     * @throws \ReflectionException
     */
    public function updated(User $model)
    {
        $birthday        = birthday_from_id_card($model->card_id);
        $model->birthday = substr($birthday, 0, 4) . '-' . substr($birthday, 4, 2) . '-' . substr($birthday, 6, 2);
        $model->age      = birthday_to_age($model->birthday);
        $admin = Admin::where('uid',$model->uid)->first();
        $adminInfo = AdminInfo::where('uid',$model->uid)->first();
        if ($admin && $adminInfo){
            foreach ($model->toArray() as $key => $value){
                if (in_array($key, ['uid','entid'])){
                    continue;
                }
                isset($admin->$key) && $admin->$key = $value;
                isset($adminInfo->$key) && $adminInfo->$key = $value;
            }
            $admin->save();
            $adminInfo->save();
        }
    }

    public function saved(User $model)
    {
        $user = User::find($model->uid);
        if ($user) {
            foreach ($model->toArray() as $key => $value) {
                if (in_array($key, ['uid', 'entid'])) {
                    continue;
                }
                if ($key === 'name') $key = 'real_name';
                isset($user->$key) && $user->$key = $value;
            }
            $user->saveQuietly();
        }
    }
}
