<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Observers;

use App\Http\Model\User\User;
use App\Http\Model\User\UserResume;

/**
 * 企业用户观察者.
 */
class ResumeObserver
{
    /**
     * Handle the Admin "creating" event.
     * @throws \Exception
     */
    public function updating(UserResume $model)
    {
        $birthday        = birthday_from_id_card($model->card_id);
        $model->birthday = substr($birthday, 0, 4) . '-' . substr($birthday, 4, 2) . '-' . substr($birthday, 6, 2);
        $model->age      = birthday_to_age($model->birthday);
    }

    public function saved(UserResume $model)
    {
        $user = User::find($model->uid);
        if ($user) {
            foreach ($model->toArray() as $key => $value) {
                if (in_array($key, ['uid', 'entid'])) {
                    continue;
                }
                if ($key === 'name') $key = 'real_name';
                isset($user->$key) && $user->$key = $value;
            }
            $user->saveQuietly();
        }
    }
}
