<?php

namespace App\Jobs\Attend;

use App\Http\Service\Attendance\AttendanceApplyRecordService;
use App\Http\Service\Company\CompanyService;
use Hhxsv5\LaravelS\Swoole\Timer\CronJob;
use Illuminate\Support\Facades\Log;

class AttendanceApplyRecordJob extends CronJob
{

    /**
     * 频率：每1m运行一次
     */
    public function interval(): int
    {
        return 1800000;
    }

    public function run(): void
    {
        try {
            $entIds = app()->get(CompanyService::class)->column(['status' => 1], 'id');
            foreach ($entIds as $entId) {
                app()->get(AttendanceApplyRecordService::class)->setEntValue($entId)->calcApplyRecordTime(now()->tz('Asia/Shanghai')->toDateString(), (int)$entId);
            }
        } catch (\Throwable $e) {
            Log::error('审批考勤更新失败：' . $e->getMessage(), ['file' => $e->getFile(), 'line' => $e->getLine()]);
        }
    }

}
