
import { obsConfig } from "@/utils/secret.js";

export let userMedia = function (constraints, success, error) {
    if (navigator.mediaDevices.getUserMedia) {
      userMedia = function (constraints, success, error) {
        navigator.mediaDevices.getUserMedia(constraints).then(success).catch(error)
      }
    } else if (navigator.webkitGetUserMedia) {
      userMedia = function (constraints, success, error) {
        navigator.webkitGetUserMedia(constraints, success, error)
      }
    } else if (navigator.mozGetUserMedia) {
      userMedia = function (constraints, success, error) {
        navigator.mozGetUserMedia(constraints, success, error)
      }
    } else if (navigator.getUserMedia) {
      userMedia = function (constraints, success, error) {
        navigator.getUserMedia(constraints, success, error)
      }
    }
  
    userMedia(constraints, success, error)
}

// 数字金额转大写
export const numToCny=(money)=>{
	// 汉字的数字
	let cnNums = new Array('零', '壹', '贰', '叁', '肆', '伍', '陆', '柒', '捌', '玖');
	// 基本单位
	let cnIntRadice = new Array('', '拾', '佰', '仟');
	// 对应整数部分扩展单位
	let cnIntUnits = new Array('', '万', '亿', '兆');
	// 对应小数部分单位
	let cnDecUnits = new Array('角', '分', '毫', '厘');
	// 整数金额时后面跟的字符
	let cnInteger = '整';
	// 整型完以后的单位
	let cnIntLast = '元';
	// 最大处理的数字
	let maxNum = 999999999999999.9999;
	// 金额整数部分
	let integerNum;
	// 金额小数部分
	let decimalNum;
	// 输出的中文金额字符串
	let chineseStr = '';
	// 分离金额后用的数组，预定义
	let parts;
	if (money == '') {
	return '';
	}
	money = parseFloat(money);
	if (money >= maxNum) {
    // 超出最大处理数字
    return '';
	}
	if (money == 0) {
    chineseStr = cnNums[0] + cnIntLast + cnInteger;
    return chineseStr;
	}
	// 转换为字符串
	money = money.toString();
	if (money.indexOf('.') == -1) {
    integerNum = money;
    decimalNum = '';
	} else {
    parts = money.split('.');
    integerNum = parts[0];
    decimalNum = parts[1].substr(0, 4);
	}
	// 获取整型部分转换
	if (parseInt(integerNum, 10) > 0) {
    let zeroCount = 0;
    let IntLen = integerNum.length;
    for (let i = 0; i < IntLen; i++) {
        let n = integerNum.substr(i, 1);
        let p = IntLen - i - 1;
        let q = p / 4;
        let m = p % 4;
        if (n == '0') {
            zeroCount++;
        } else {
            if (zeroCount > 0) {
                chineseStr += cnNums[0];
            }
            // 归零
            zeroCount = 0;
            chineseStr += cnNums[parseInt(n)]
                + cnIntRadice[m];
        }
        if (m == 0 && zeroCount < 4) {
            chineseStr += cnIntUnits[q];
        }
    }
    chineseStr += cnIntLast;
	}
	// 小数部分
	if (decimalNum != '') {
    let decLen = decimalNum.length;
    for (let i = 0; i < decLen; i++) {
        let n = decimalNum.substr(i, 1);
        if (n != '0') {
            chineseStr += cnNums[Number(n)] + cnDecUnits[i];
        }
    }
	}
	if (chineseStr == '') {
    chineseStr += cnNums[0] + cnIntLast + cnInteger;
	} else if (decimalNum == '') {
    chineseStr += cnInteger;
	}
	return chineseStr;
}

// 上传文件到obs
export const uploadObs = (file, domainId) => {
  return new Promise((resolve, reject) => {
    const now = new Date();
    const y = now.getFullYear();
    const m = now.getMonth()+1<10?'0'+(now.getMonth()+1):now.getMonth()+1;
    const d = now.getDate()<10?'0'+now.getDate():now.getDate();
    const md = m+'-'+d;
    const objectKey=`uploads/${y}/${md}/${domainId}/${now.getTime()}/${file.name}`;
    // eslint-disable-next-line no-undef
    const obs = new ObsClient({
      access_key_id: obsConfig.ak,
      secret_access_key: obsConfig.sk,
      server : obsConfig.urlserver,
      timeout : 60 * 5,
    });
    obs.putObject({
      Bucket: obsConfig.BucketName,
      Key : objectKey,
      SourceFile: file //获取file文件
    }).then(function(result) {
      if(result.CommonMsg.Status < 300){
        const httpurl = `https://${obsConfig.BucketName}.${obsConfig.urlserver}/${objectKey}`;
        resolve(httpurl);
      }else{
        reject(false);
      }
    }).catch(()=>{
      reject(false);
    });
  });
}