import axios from 'axios';
import { Message } from 'element-ui'
// import { ElMessage, ElMessageBox } from 'element-plus';
// import { Session } from '/@/utils/storage';
// import qs from 'qs';
 
// 配置新建一个 axios 实例
const service = axios.create({
	baseURL: window.location.origin,
	timeout: 50000,
	headers: { 
        "Content-Type": "application/json"
    },
});
 
// 添加请求拦截器
service.interceptors.request.use(
	(config) => {
		// console.log("🚀 ~ config:", config.data)
		if(!config.url.includes('/api/v2/recogInvoive.do')){
			const accessToken = localStorage.getItem("accessToken");
			if (accessToken) {
				config.headers.accessToken = accessToken;
			}
		}
		return config;
	},
	(error) => {
		// 对请求错误做些什么
		return Promise.reject(error);
	}
);
 
// 添加响应拦截器
service.interceptors.response.use(
	(response) => {
        let res = response.data;
		// 对响应数据做点什么
        if(response.headers["x-subject-token"]){
            res = {...response.data, "x-subject-token": response.headers["x-subject-token"]};
        }
		if (res.code && res.code !== 0) {
			// `token` 过期或者账号已在别处登录
			if (res.code === 401) {
				window.location.href = '/'; // 去登录页
				// ElMessageBox.alert('你已被登出，请重新登录', '提示', {})
				// 	.then(() => { })
				// 	.catch(() => { });
				// console.log("🚀 ~ service.interceptors.response:", service.interceptors.response)
				// return Promise.reject(service.interceptors.response);
			} else {
				return res;
			}
		} else {
			return res;
		}
	},
	(error) => {
		// console.log("🚀 ~ error:", error)
		// 对响应错误做点什么
		if (error.message.indexOf('timeout') != -1) {
            Message.error('网络超时');
		} else if (error.message == 'Network Error') {
            Message.error('网络连接错误');
		} else {
			if (error.response.data) {
				Message.error(error.response.data.message || error.response.statusText);
			}else Message.error('接口路径找不到');
		}
		return Promise.reject(error);
	}
);
 
// 导出 axios 实例
export default service;