import Vue from "vue";
import Router from "vue-router";
Vue.use(Router);

//在使用push或者replace的时候，需要使用catch来处理异常
const originalPush = Router.prototype.push;
// 重写了原型上的push方法，统一的处理了错误信息
Router.prototype.push = function push(location) {
  return originalPush.call(this, location).catch((err) => err);
};

// const _import = require('./_import_' + process.env.NODE_ENV)
import Layout from "@/views/Layout/layout";

//路由页面路径公共函数
function getViews(path) {
  return (resolve) => {
    require.ensure([], (require) => {
      resolve(require("@/views/" + path));
    });
  };
}
export const constantRouterMap = [
  {
    path: "/Login",
    component: (resolve) => require(["@/views/Login/index"], resolve),
    hidden: true,
  },
  // {
  //   path: "/",
  //   component: (resolve) => require(["@/views/Home"], resolve),
  //   hidden: true,
  //   redirect: "/Home",
  //   name: "首页",
  //   children: [
  //     {
  //       path: "Home",
  //       name: "首页",
  //       component: (resolve) => require(["@/views/Home"], resolve),
  //       meta: { title: "Home" },
  //     },
  //   ],
  // },
  {
    path: "/Ruzhi",
    component: (resolve) => require(["@/views/Ruzhi"], resolve), //test
    hidden: true,
  },
  {
    path: "/test",
    component: (resolve) => require(["@/views/test"], resolve), //test
    hidden: true,
  },
  {
    path: "/DepartmentsList",
    component: (resolve) => require(["@/views/DepartmentsList"], resolve), //部门列表
    hidden: true,
  },
  {
    path: "/DepartAdmin",
    component: (resolve) => require(["@/views/DepartAdmin"], resolve), //部门管理员
    hidden: true,
  },
  {
    path: "/Group",
    component: (resolve) => require(["@/views/Group"], resolve), //集团组织
    hidden: true,
  },
  {
    path: "/Organization",
    component: (resolve) => require(["@/views/Organization"], resolve), //组织类型
    hidden: true,
  },
  {
    path: "/Role",
    component: (resolve) => require(["@/views/Role"], resolve), //角色管理
    hidden: true,
  },
  {
    path: "/GraphArchitecture",
    component: (resolve) => require(["@/views/GraphArchitecture"], resolve), //集团架构图
    hidden: true,
  },
  {
    path: "/Employee",
    component: (resolve) => require(["@/views/Employee"], resolve), //在职员工
    hidden: true,
  },
  {
    path: "/EmployeeLeave",
    component: (resolve) => require(["@/views/EmployeeLeave"], resolve), //离职管理
    hidden: true,
  },
  {
    path: "/Contract",
    component: (resolve) => require(["@/views/Contract"], resolve), //合同管理
    hidden: true,
  },
  {
    path: "/AuthList",
    component: (resolve) => require(["@/views/AuthList"], resolve), //授权列表
    hidden: true,
  },
  {
    path: "/AuthListV2",
    component: (resolve) => require(["@/views/AuthListV2"], resolve), //授权列表
    hidden: true,
  },
  {
    path: "/ApproveOrg",
    component: (resolve) => require(["@/views/ApproveOrg"], resolve), //审批企业
    hidden: true,
  },
  {
    path: "/PatchSearchCert",
    component: (resolve) => require(["@/views/PatchSearchCert"], resolve), //批量查询证书信息
    hidden: true,
  },
  {
    path: "/QueryList",
    component: (resolve) => require(["@/views/QueryList"], resolve), //编辑器
    hidden: true,
  },
  {
    path: "/ChangeLogs",
    component: (resolve) => require(["@/views/ChangeLogs"], resolve), //编辑器
    hidden: true,
  },
  {
    path: "/CompletionCert",
    component: (resolve) => require(["@/views/CompletionCert"], resolve), //哈尔滨结业证
    hidden: true,
  },
  {
    path: "/elesign",
    component: (resolve) => require(["@/views/Elesign"], resolve), //电子签章html页面
    hidden: true,
  },
  {
    path: "/map",
    component: (resolve) => require(["@/views/Map"], resolve), //高德地图
    hidden: true,
  },
  {
    path: "/404",
    component: (resolve) => require(["@/views/404"], resolve),
    hidden: true,
  },
];

export default new Router({
  // mode: 'history',
  scrollBehavior: () => ({
    y: 0,
  }),
  routes: constantRouterMap,
});

//获取后台动态路由
var runAsyncRouterMap = function (previewTreeData) {
  //store/modules/user.js 左边菜单传参第三步 3
  var RouterMap = new Promise(function (resolve) {
    //左上角下拉选择小区，根据小区显示不同的左边菜单start
    var rdata = [];
    rdata=[]
    rdata.push({ path: "*", redirect: "/404", hidden: true });
    resolve(rdata);
    //右上角下拉选择小区，根据小区显示不同的左边菜单end
  });
  return RouterMap;
};

export { runAsyncRouterMap };
