import request from "@/utils/Request";
import qs from "qs";
var domainId = localStorage.getItem("domainId") || ""; //从本地获取组织id
console.log("domainId" + domainId);

import axios from "axios";
// 创建axios实例
const service = axios.create({
  timeout: 60000,
});
service.interceptors.request.use(
  async (config) => {
    config.baseURL = "https://api.tianditu.gov.cn";
    config.params = {
      postStr: JSON.stringify({
        ...config.params,
      }),
      type: "query",
      tk: '18111c7ecf3f616faf921e930914e879',
    };
    return config;
  },
  (error) => {
    return Promise.reject(error);
  }
);
/**
 * 搜索POI-天地图
 * @param params
 * @returns {Promise<AxiosResponse<any>>}
 */
export const getPlaceByTiandi = (params) => {
  return service({
    url: "/v2/search?",
    method: "GET",
    map: "tianditu",
    params,
  });
};

// 查询部门
export function StaffDepartmentListApi(obj2, hideLoading) {
  return request({
    url: `/tenant/organizations/${domainId}/departments`,
    method: "get",
    data: {},
    hideLoading
  });
}
// 获取部门员工列表
export function getDepEmpListApi(data) {
  return request({
    url: `/tenant/users/current/organizations/${domainId}/departs/${data}/contacts`,
    method: "get",
  });
}

// 新增部门
export function AddDepartmentsApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/departments`,
    method: "post",
    data: {
      name: obj.name,
      parentId: obj.parentId,
      displayOrder: obj.displayOrder,
      permissionType: obj.permissionType,
      allowedDepartIds: obj.allowedDepartIds,
      leaderEmployeeIdList: obj.leaderEmployeeIdList,
      allowedDepartIds:
        obj.permissionType == "Special" ? obj.allowedDepartIds : [], //可见指定部门（支持多选）
    },
  });
}

// 编辑部门
export function EditDepartmentsApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/departments/${obj.id}`,
    method: "put",
    data: {
      id: obj.id,
      name: obj.name,
      parentId: obj.parentId,
      displayOrder: obj.displayOrder,
      permissionType: obj.permissionType,
      allowedDepartIds: obj.allowedDepartIds,
      leaderEmployeeIdList: obj.leaderEmployeeIdList,

      allowedDepartIds:
        obj.permissionType == "Special" ? obj.allowedDepartIds : [], //可见指定部门（支持多选）
    },
  });
}
// 删除部门
export function delDepartmentsApi(ids, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/departments/batch-delete`,
    method: "post",
    data: {
      ids: ids,
    },
  });
}
// 导入部门
export function batchImportApi(path, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/departments/batch-import`,
    method: "post",
    data: {
      path: path,
    },
  });
}
// 转移部门成员
export function batchMoveDepartmentsApi(obj, fromDepartIds, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/departments/batch-move`,
    method: "post",
    data: {
      fromDepartIds: fromDepartIds,
      destDepartId: obj.destDepartId,
    },
  });
}
// 批量转移成员
export function batchMoveUserApi(obj, employeeIds, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/department-movement`,
    method: "post",
    data: {
      employeeIds: employeeIds,
      destDepartId: obj.destDepartId,
    },
  });
}
// 批量设置通讯录权限
export function batchImDepartmentsApi(obj, departIds, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/departments/batch-assign-im`,
    method: "post",
    data: {
      departIds: departIds,
      permissionType: obj.permissionType,
      allowedDepartIds: obj.allowedDepartIds,
    },
  });
}
//修改部门顺序信息
export function displayOrderApi(row, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/departments/${row.id}/display-order`,
    method: "post",
    data: {
      displayOrder: Number(row.displayOrder),
      id: row.id,
    },
  });
}
//根据部门查询人员列表
export function UserDeptListApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/search`,
    method: "post",
    data: {
      departIds: obj.departIds,
      pageIndex: obj.pageIndex,
      pageSize: obj.pageSize,
    },
  });
}
//添加员工
export function AddUserEmplyeeApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees`,
    method: "post",
    data: {
      name: obj.name,
      telephone: obj.telephone,
      departId: obj.departId,
      occupationType: obj.occupationType,
      hiredDate: obj.hiredDate,
      credential: obj.credential,
      position: obj.position,
      abnormalPersonnelConfirm: obj.abnormalPersonnelConfirm
    },
  });
}

//变更职业类型
export function changeOccupationTypeApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/change-occupation-type`,
    method: "post",
    data: {
      employeeId: obj.employeeId,
      occupationType: obj.occupationType,
    },
  });
}

//获取在职员工列表
export function employeeTableListApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/search`,
    method: "post",
    data,
    // data: {
    //   authenticatedStatuses:obj.authenticatedStatuses,//实名状态
    //   credentialTypes:obj.credentialTypes,//证件类型
    //   departIds:obj.departIds,//所在部门
    //   hiredDate:obj.hiredDate,//入职日期
    //   keyword:obj.keyword,//关键词
    //   occupationTypes:obj.occupationTypes,//职业类型
    //   userTypes:obj.userTypes,
    //   checkedStatuses:obj.checkedStatuses,//证件核验状态
    //   cerStatus:obj.cerStatus,//持资格证
    //   contractStatus:obj.contractStatus,//签订合同
    //   pageIndex:obj.pageIndex,
    //   pageSize:obj.pageSize
    // },
  });
}
//部门列表--编辑-根据员工id获取部门管理
export function getEmployeeIddepartAdminsApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/depart-admins/get-by-employee-id/${data.employeeId}`,
    method: "get",
  });
}
//部门列表--查看成员--查询过滤该部门在职员工列表
export function SearchDepartmentsListEmplyeeApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/search`,
    method: "post",
    data,
  });
}
//查询在职员工列表
export function SearchEmplyeeApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/search`,
    method: "post",
    data: {
      keyword: data.keyword, //关键词
      pageIndex: data.pageIndex,
      pageSize: data.pageSize,
    },
  });
}
//高级查询在职员工列表
export function highSearchEmplyeeApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/search`,
    method: "post",
    data,
    // data: {
    //   authenticatedStatuses:obj.authenticatedStatuses,//实名状态
    //   credentialTypes:obj.credentialTypes,//证件类型
    //   departIds:obj.departIds,//所在部门
    //   hiredDate:obj.hiredDate,//入职日期
    //   keyword:obj.keyword,//关键词
    //   occupationTypes:obj.occupationTypes,//职业类型
    //   userTypes:obj.userTypes,
    //   checkedStatuses:obj.checkedStatuses,//证件核验状态
    //   cerStatus:obj.cerStatus,//持资格证
    //   contractStatus:obj.contractStatus,//签订合同
    //   pageIndex:obj.pageIndex,
    //   pageSize:obj.pageSize
    // },
  });
}

//获取在职员工列表--数据看板数据总量
export function employeeTableBoardListApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/searchReport`,
    method: "post",
    data,
    // data: {
    //   authenticatedStatuses:obj.authenticatedStatuses,//实名状态
    //   credentialTypes:obj.credentialTypes,//证件类型
    //   departIds:obj.departIds,//所在部门
    //   hiredDate:obj.hiredDate,//入职日期
    //   keyword:obj.keyword,//关键词
    //   occupationTypes:obj.occupationTypes,//职业类型
    //   userTypes:obj.userTypes,
    //   checkedStatuses:obj.checkedStatuses,//证件核验状态
    //   cerStatus:obj.cerStatus,//持资格证
    //   contractStatus:obj.contractStatus,//签订合同
    //   pageIndex:obj.pageIndex,
    //   pageSize:obj.pageSize
    // },
  });
}
// 编辑查询员工基本信息
export function employessBaseInfoApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/${obj.id}`,
    method: "get",
    data: {},
  });
}

// 导入员工
export function batchImportEmloyeeApi(path, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/batch-import`,
    method: "post",
    data: {
      path: path,
    },
  });
}

// 导出员工--查询导出字段
export function getExportEmployeeColumnsApi(obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/getExportColumns`,
    method: "post",
    data: {},
  });
}

//导出员工--根据字段导出
export function exportExcelEmployeeApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/exportExcel`,
    method: "post",
    responseType: "blob",
    data: data,
  });
}

//导出员工下载模板
export function downloadEmployeeExcelApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/exportEmployeeTemp`,
    method: "get",
    responseType: "blob",
    data: data,
  });
}

// 在职员工-重置密码
export function resetPWDStaffApi(row, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/${row.id}/resetPassword`,
    method: "post",
    data: {},
  });
}

// 查询部门管理员列表
export function StaffDepartmentAdminListApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/depart-admins/search`,
    method: "post",
    data,
  });
}

// 添加部门管理员
export function AddDepartmentsAdminApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/depart-admins/batch-create`,
    method: "post",
    data: {
      departIds: obj.departIds,
      employeeIds: obj.employeeIds,
    },
  });
}

// 编辑部门管理员
export function EditDepartmentsAdminApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/depart-admins/update`,
    method: "post",
    data: {
      departIds: obj.departIds,
      employeeId: obj.employeeId,
    },
  });
}
// 批量删除部门管理员
export function delDepartmentsAdminApi(ids, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/depart-admins/batch-delete`,
    method: "post",
    data: {
      employeeIds: ids,
    },
  });
}
//获取离职员工列表
export function employeeTableListLeaveApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/search-leave`,
    method: "post",
    data: {
      keyword: obj.keyword, //关键词
      pageIndex: obj.pageIndex,
      pageSize: obj.pageSize,
      startDate: obj.startDate,
      endDate: obj.endDate,
      insure: obj.insure,
      departIds: obj.departIds,
    },
  });
}
//办理离职
export function AddUserEmplyeeLeaveApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/batch-leave`,
    method: "post",
    data: {
      ids: obj.employeeIds,
      expectedDate: obj.expectedDate,
      note: obj.note,
    },
  });
}

// 导入离职
export function batchImportEmloyeeLeaveApi(path, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/batch-leave-excel`,
    method: "post",
    data: {
      path: path,
    },
  });
}

//办理离职-转移上级身份
export function AddUserEmplyeeLeaveMoveSuperApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/batch-assign-superior`,
    method: "post",
    data: {
      items: obj,
    },
  });
}

//员工复职
export function AddUserEmplyeeBackApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/go-back`,
    method: "post",
    data: {
      id: obj.id,
      departId: obj.departId,
      occupationType: obj.occupationType,
      hiredDate: obj.hiredDate,
    },
  });
}

//添加合同
export function AddContractApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/contracts`,
    method: "post",
    data: {
      name: obj.name,
      employeeId: obj.employeeId,
      aName: obj.aName,
      bName: obj.bName,
      beginDate: obj.beginDate,
      endDate: obj.endDate,
      dateLimitless: obj.dateLimitless,
      attachment: obj.attachment,
      note: obj.note,
    },
  });
}

//编辑合同
export function EditContractApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/contracts/${obj.id}`,
    method: "put",
    data: {
      id: obj.id,
      name: obj.name,
      employeeId: obj.employeeId,
      aName: obj.aName,
      bName: obj.bName,
      beginDate: obj.beginDate,
      endDate: obj.endDate,
      dateLimitless: obj.dateLimitless,
      attachment: obj.attachment,
      note: obj.note,
    },
  });
}
//查询合同--各种搜索条件查询
export function contractListSearchApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/contracts/search`,
    method: "post",
    data,
  });
}

//查询合同--根据关键字查询
export function contractListSearchKeywordApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/contracts/search`,
    method: "post",
    data: {
      keyword: data.keyword, //关键词
      pageIndex: data.pageIndex,
      pageSize: data.pageSize,
    },
  });
}

//在职员工--编辑--根据职员id查询合同
export function contractEmployeeListApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/contracts/search`,
    method: "post",
    data: {
      employeeId: data.employeeId || "",
      keyword: data.keyword, //关键词
      pageIndex: data.pageIndex,
      pageSize: data.pageSize,
    },
  });
}
//在职员工--编辑--合同信息--下载合同电子文件
// export function contractDownloadLocalApi(data) {
//   return request({
//     url: `/tenant/organizations/${domainId}/contracts/contractDownloadLocal/${data.id}`,
//     method: "get",
//     data: {},
//   });
// }

//高级查询合同列表
export function highSearchContractApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/contracts/search`,
    method: "post",
    data,
  });
}

// 导入合同
export function batchImportContractApi(path, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/contracts/batch-import`,
    method: "post",
    data: {
      path: path,
    },
  });
}
// 删除合同
export function delContractApi(id, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/contracts/${id}`,
    method: "delete",
    data: {},
  });
}

// 批量删除合同
export function delcontractsApi(ids, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/contracts/batch-delete`,
    method: "post",
    data: {
      ids: ids,
    },
  });
}

//合同--数据看板数据总量
export function contractTableBoardListApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/contracts/searchReport`,
    method: "post",
    data,
    // data: {
    //   authenticatedStatuses:obj.authenticatedStatuses,//实名状态
    //   credentialTypes:obj.credentialTypes,//证件类型
    //   departIds:obj.departIds,//所在部门
    //   hiredDate:obj.hiredDate,//入职日期
    //   keyword:obj.keyword,//关键词
    //   occupationTypes:obj.occupationTypes,//职业类型
    //   userTypes:obj.userTypes,
    //   checkedStatuses:obj.checkedStatuses,//证件核验状态
    //   cerStatus:obj.cerStatus,//持资格证
    //   contractStatus:obj.contractStatus,//签订合同
    //   pageIndex:obj.pageIndex,
    //   pageSize:obj.pageSize
    // },
  });
}
//查询授权列表
export function AuthListApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/permissions/search`,
    method: "post",
    data: {
      keyword: obj.keyword,
      departIds: obj.departIds,
      occupationTypes: obj.occupationTypes,
      pageIndex: obj.pageIndex,
      pageSize: obj.pageSize,
    },
  });
}
//查询授权应用角色权限树
export function myappsAuthListApi(obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/my-apps`,
    method: "get",
    data: {},
  });
}
//新增授权
export function AddAuthListApi(employeeIds, roleIds, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/batch-roles`,
    method: "post",
    data: {
      employeeIds: employeeIds,
      roleIds: roleIds,
    },
  });
}
//编辑授权查询回显弹窗
export function EmployIdGetRoleListApi(employeeId, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/${employeeId}/roles`,
    method: "get",
    data: {},
  });
}

//编辑用户--保存详细信息
export function staffDetailInfoApi(obj, formList) {
  return request({
    url: `/tenant/users/${obj.id}/detail`,
    method: "put",
    data: {
      sex: formList.sex,
      birthdate: formList.birthdate,
      nation: formList.nation,
      education: formList.education,
      politicsStatus: formList.politicsStatus,
      householdType: formList.householdType,
      nativePlace: formList.nativePlace,
      maritalStatus: formList.maritalStatus,
      stature: formList.stature,
      militaryStatus: formList.militaryStatus,
      emergencyContact: formList.emergencyContact,
      emergencyPhone: formList.emergencyPhone,
      licenseLevel: formList.licenseLevel,
      workYear: formList.workYear,
      diseasesHistory: formList.diseasesHistory,
      placeOfNow: formList.placeOfNow,
    },
  });
}
//编辑用户--保存拓展信息
export function staffExtendInfoApi(id, formList) {
  return request({
    url: `/tenant/users/${id}/save/extension`,
    method: "post",
    data: {
      extensionList: formList.extensionList
    },
  });
}
//编辑证件信息--保存详细信息
export function staffCertInfoApi(obj, formList) {
  return request({
    // url: `/tenant/users/current/update-credential`,
    // url: `/tenant/users/${obj.id}/credential`,
    url: `/tenant/organizations/${domainId}/employees/${obj.id}/edit-credential`,
    method: "post",
    data: {
      ...formList,
    },
  });
}
//编辑用户--变更用户姓名/手机信息
export function StaffbaseInfoApi(obj, formList) {
  return request({
    url: `/tenant/users/${obj.id}/basic`,
    method: "put",
    data: {
      name: formList.name,
      telephone: formList.telephone,
    },
  });
}
//编辑用户--修改就职信息
export function staffOfficeInfoApi(obj, obj2, formList) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/${obj.id}`,
    method: "put",
    data: {
      departIds: formList.departId,
      hiredDate: formList.hiredDate,
      position: formList.position,
      positiveDate: formList.positiveDate,
      superiorId: formList.superiorId,
      personStatus: formList.personStatus,
      probation: formList.probation,
      salary: formList.salary + '',

      planPositiveDate: formList.planPositiveDate,
      interview: formList.fileList,
    },
  });
}
//获取审批企业列表
export function approveOrgTableListApi(obj) {
  return request({
    url: `/tenant/organizations/search`,
    method: "post",
    data: obj,
  });
}
//保存审批详情
export function ApproveSubmitApi(obj, organizationId) {
  return request({
    url: `/tenant/organizations/${organizationId}/approved/update`,
    method: "post",
    data: obj,
  });
}

//点击审批企业
export function ApprovedOrgBtnApi(organizationId, data = {
  approved: true, //审批通过
  note: "", //备注
}) {
  return request({
    url: `/tenant/organizations/${organizationId}/approved`,
    method: "put",
    data,
  });
}
//公共文件上传Api
export function commonFileUploadApi(obj) {
  return request({
    url: `/shared/common/resources`,
    method: "post",
    responseType: "blob",
    data: obj,
    upload_type: true,
  });
}
//查询保险列表--ComServiceApi 前端统一以这个自定义的前缀代理公共服务
export function SafeListListApi(obj, idCardNo) {
  return request({
    url: `/ComServiceApi/enterprise/ins/com-ins/get-per-ins-page-new`,
    method: "post",
    data: {
      pageNumber: obj.pageIndex,
      pageSize: obj.pageSize,
      idCardNo: idCardNo,
    },
  });
}

//就职记录
export function employeeRecordsListApi(obj) {
  return request({
    url: `/tenant/organizations/${domainId}/employee-records`,
    method: "post",
    data: obj,
  });
}

//心理测评记录
export function mentalTestListApi(id) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/${id}/xlcps`,
    method: "post",
    data: {},
  });
}

//添加邀请入职
export function AddInviteDepartApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/add-invite-depart`,
    method: "post",
    data: {
      departId: obj.departId,
      occupationType: obj.occupationType,
      endTime: obj.endTime,
    },
  });
}
//获取驻勤列表
export function dutyListApi(obj2) {
  return request({
    url: `/organizations/${domainId}/attendSite/list`,
    method: "get",
    data: {},
  });
}
//添加邀请驻勤
export function AddDutyApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/add-invite-attend-site`,
    method: "post",
    data: {
      attendSiteId: obj.attendSiteId,
      attendSiteName: obj.attendSiteName,
      departId: obj.departId,
      endTime: obj.endTime,
    },
  });
}

//查询证书--55
export function certListApi(obj, obj2, id) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/${id}/credentials`,
    method: "post",
    data: {
      pageIndex: obj.pageIndex,
      pageSize: obj.pageSize,
      credentialTypes: [7, 8, 9], //7代表资格证，8等级证,9结业证
      skipAreaCodeFilter: true, //是否过滤区域证书，true只能查询自己所属区域
    },
  });
}

// 根据userid与证件号码查询资格证书
export function getcredentialDetailsApi(obj, type, number) {
  return request({
    url: `/tenant/users/${obj.id}/${type}/${number}`,
    method: "get",
    data: {},
  });
}

//查询组织详情
export function ApprovedOrgDetailApi(obj, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/getDetail?approveOrganId=${obj.id}`,
    method: "get",
    data: {},
  });
}
//查询sass字典表
export function sassdictListApi(obj, obj2) {
  return request({
    url: `/shared/common/dict/all`,
    method: "get",
    data: {},
  });
}
//查询省市区
export function cityOptionsListApi() {
  return request({
    url: `/shared/common/region/all`,
    method: "get",
    data: {},
  });
}

// 获取组织注册字典表
export function dictRegisterListApi() {
  return request({
    url: `/shared/common/dict/register`,
    method: "get",
    data: {},
  });
}
// 根据监管地区改变查询监管机构接口
export function placeOfSuperviseCodeChangeDepartIdApi(
  provideCode,
  industryCode
) {
  console.info("industryCode", industryCode);
  return request({
    url: `/shared/common/supervise/find/tree/${provideCode}/${industryCode}`,
    method: "get",
    data: {},
  });
}

//组织开通审核导出
export function exportOrgExcelApproveOrgApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/exportOrgExcel`,
    method: "post",
    responseType: "blob",
    data: data,
  });
}

//合同导出
export function exportContractExcelApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/contracts/exportExcel`,
    method: "post",
    responseType: "blob",
    data: data,
  });
}

//部门列表导出
export function exportDepartListExcelApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/departments/exportExcel`,
    method: "post",
    responseType: "blob",
    data: data,
  });
}
//离职导出
export function exportLeaveExcelApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/exportLeaveExcel`,
    method: "post",
    responseType: "blob",
    data: data,
  });
}
//导出离职证明
export function exportLeaveExcelWordApi(data, obj2) {
  return request({
    url: `/tenant/organizations/${domainId}/employees/exportLeaveWord/${data.id}`,
    method: "get",
    responseType: "blob",
    data: {},
  });
}
// 图片文件上传
export function uploadFileApi(formData) {
  return request({
    url: `/shared/common/resources`,
    method: "post",
    data: formData,
  });
}

// 证书批量查询
export function batchImportSearchCertApi(path, obj2) {
  return request({
    url: `/organizations/${domainId}/certificate/batch-query-cers`,
    method: "post",
    data: {
      path: path,
    },
  });
}

// 映射列表查询
export function getChangeMappingApi() {
  return request({
    url: `/obpm/v3/extends/change-mapping`,
    method: "get",
    data: {},
  });
}
// 映射信息详情
export function getChangeMappingDetailsApi(data) {
  return request({
    url: `/obpm/v3/extends/change-mapping/${data.id}`,
    method: "get",
    data: {},
  });
}
// 映射信息修改
export function putChangeMappingDetailsApi(data) {
  return request({
    url: `/obpm/v3/extends/change-mapping/${data.id}`,
    method: "put",
    data: data.params,
  });
}
// 映射信息新增
export function postChangeMappingApi(data) {
  return request({
    url: `/obpm/v3/extends/change-mapping`,
    method: "post",
    data: data,
  });
}
// 增量数据列表
export function getchangeLogsApi(data) {
  return request({
    url: `/obpm/v3/extends/change-logs`,
    method: "get",
  });
}
// 增量数据明细
export function getchangeLogsDetailApi(data) {
  return request({
    url: `/obpm/v3/extends/change-logs/${data.id}`,
    method: "get",
  });
}
// 增量数据添加
export function postchangeLogsApi(data) {
  return request({
    url: `/obpm/v3/extends/change-logs`,
    method: "post",
    data: data,
  });
}

// 下载自动模板
export function templateDownloadApi(data) {
  return request({
    url: `/obpm/v3/extends/change-logs/template/download`,
    method: "get",
    data: data,
  });
}

// 获取表列表
export function metaTablesApi(data) {
  return request({
    url: `/obpm/v3/extends/change-logs/meta/tables`,
    method: "get",
    data: data,
  });
}

// 导出部门管理员


//组织开通审核导出
export function exportDepartAdminList(data, obj2) {
  return request({

    url: `/tenant/organizations/${obj2.domainId}/depart-admins/exportExcel`,
    method: "post",
    responseType: "blob",
    data: data,
  });
}
/* ----------- 赟帅 */
// 企业新增自定义角色
export function addRole(data, organizationId) {
  return request({
    url: `/tenant/organizations/${organizationId}/role/add`,
    method: "post",
    data: data,
  });
}


// 分页查询用户职员列表
export function getRoleUserList(data, organizationId) {
  return request({
    url: `/tenant/organizations/${organizationId}/role/user/page`,
    method: "post",
    data: data,
  });
}
// 删除角色 单个或批量
export function deleteRoleUser(data, organizationId) {
  return request({
    url: `/tenant/organizations/${organizationId}/role/delete`,
    method: "post",
    data: data,
  });
}

// 根据角色，批量设置成员
export function bacthSetEmployees(data, organizationId) {
  return request({
    url: `/tenant/organizations/${domainId}/role/add/roles/employees`,
    method: "post",
    data: data,
  });
}
// 导入模板
export function batchImportRole(data, organizationId, roleId) {
  return request({
    url: `/tenant/organizations/${organizationId}/role/${roleId}/import/member`,
    method: "post",
    data: data,
    responseType: "blob",

  });
}
// 批量移除成员
export function batchDeleteUser(data, organizationId) {
  return request({
    url: `/tenant/organizations/${organizationId}/role/delete/role/employees`,
    method: "post",
    data: data,

  });
}



/* ------------- */

/* ----------蔡伟鹏 */


// 功能授权分页列表
export function getRoleUserListApi(data) {
  return request({
    url: `/tenant/organizations/${domainId}/role/user/page`,
    method: "post",
    data,
  });
}

// 提交数据
export function getruzhiqueren(data) {
  return request({
    url: `/tenant/organizations/${domainId}/invitedToJoinQueues/action`,
    method: "post",
    data,
  });
}

// 企业编辑角色
export function editRole(data, organizationId) {
  return request({
    url: `/tenant/organizations/${organizationId}/role/edit`,
    method: "post",
    data: data,
  });
}

// 企业复制角色
export function copyRole(data, organizationId) {
  return request({
    url: `/tenant/organizations/${organizationId}/role/copy`,
    method: "post",
    data: data,
  });
}

// 获取企业自定义角色列表
export function getRoleList(data, organizationId) {
  return request({
    url: `/tenant/organizations/${organizationId}/role/search`,
    method: "post",
    data: data,
  });
}
// 下载模板
export function downLoadRoleTp(organizationId) {
  return request({
    url: `/tenant/organizations/${organizationId}/role/download/import/member/template`,
    method: "post",
    responseType: "blob",
  });
}

// 查询企业授权的应用列表
export function getPermitAppListApi(data) {
  return request({
    url: `/tenant/organizations/${domainId}/permit/list`,
    // url: `/tenant/organizations/current/organizations/${domainId}/departs/${data}/contacts`,
    // /v3/tenant/organizations/{organizationId}/permit/app/list
    method: "post",
    data
  });
}

// 功能授权保存
export function savePermitAuthListApi(data) {
  return request({
    url: `/tenant/organizations/${domainId}/permit/auth`,
    method: "post",
    data,
  });
}

// 职员功能授权获取
export function getPermitAllAuthListApi(employeeId) {
  return request({
    url: `/tenant/organizations/${domainId}/permit/get/all/${employeeId}`,
    method: "post",
  });
}

// 查询应用列表
export function getPermitAppOptionListApi(item) {
  return request({
    url: `/tenant/organizations/${domainId}/permit/${item.appId}/option/list`,
    // url: `/tenant/organizations/current/organizations/${domainId}/departs/${data}/contacts`,
    // /v3/tenant/organizations/{organizationId}/permit/app/list
    method: "post",
  });
}

// 获取职员功能应用
export function getPermitAppEmployeeApi(item) {
  return request({
    url: `/tenant/organizations/${domainId}/permit/get/all/${item.employeeId}`,
    // url: `/tenant/organizations/current/organizations/${domainId}/departs/${data}/contacts`,
    // /v3/tenant/organizations/{organizationId}/permit/app/list
    method: "post",
  });
}

// 根据职员id，查询该职员所有的功能授权，包括个人和角色授权  显示职员拥有哪些授权的时候调用
export function getPermitApiInIdall(employeeId) {
  return request({
    url: `/tenant/organizations/${domainId}/permit/get/all/${employeeId}`,
    method: "post",
  });
}

// 根据职员id，查询该职员所有的功能授权，包括个人和角色授权   职员授权编辑的时候调用
export function getPermitApiInIdemployee(employeeId) {
  return request({
    url: `/tenant/organizations/${domainId}/permit/get/employee/${employeeId}`,
    method: "post",
  });
}

// 获取职员功能应用 角色授权编辑的时候调用
export function getPermitApiInIdrole(roleId) {
  return request({
    url: `/tenant/organizations/${domainId}/permit/get/role/${roleId}`,
    method: "post",
  });
}

// 根据职员id、角色id列表，批量设置角色关联
export function employeeToRoles(data) {
  return request({
    url: `/tenant/organizations/${domainId}/role/add/employee/roles`,
    method: "post",
    data
  });
}

export function getORGList(data) {
  return request({
    url: `/tenant/organizations/${domainId}/organizationRelationship/structure`,
    method: "get",

  });
}

// 生成集团码
export function codeGNT(data) {
  return request({
    url: `/tenant/inviteOrganizationRelationship/findGroupCodeByOrganizationId/${domainId}`,
    method: "get",

  });
}

// 根据职员id、角色id列表，批量删除用户关联
export function employeebacthDeleteroles(data) {
  return request({
    url: `/tenant/organizations/${domainId}/role/delete/employee/roles`,
    method: "post",
    data
  });
}

// 获取公司管理员
export function getAdminList(selectedOrganizationId) {
  return request({
    url: `/tenant/organizations/${selectedOrganizationId}/employees/admins`,
    method: "get",
  });
}

// 获取组织类型
export function getfindByOrganizationId(data) {
  return request({
    url: `/tenant/organizationType/findByOrganizationId/${domainId}`,
    method: "get",
  });
}

// 新增类型
export function addByOrganizationId(data) {
  return request({
    url: `/tenant/organizationType/save`,
    method: "post",
    data
  });
}

// 新增类型
export function updateByOrganizationId(data) {
  return request({
    url: `/tenant/organizationType/update`,
    method: "put",
    data
  });
}

// 删除类型
export function deleteByOrganizationId(id) {
  return request({
    url: `/tenant/organizationType/delete/${id}`,
    method: "delete",
  });
}

// 更新集团组织状态
export function updateOrganizationStatus(data) {
  return request({
    url: `/tenant/organizations/${domainId}/organizationRelationship/status/update`,
    method: "put",
    data
  });
}

// 更新集团组织详情
export function updateOrganizationInfo(data) {
  return request({
    url: `/tenant/organizations/${domainId}/organizationRelationship/info`,
    method: "put",
    data
  });
}

// 删除组织集团关系
export function deleteOrganizationInfo(data) {
  return request({
    url: `/tenant/organizations/${domainId}/organizationRelationship/delete`,
    method: "delete",
    data
  });
}

// 获取列表
export function getruzhilist(data) {
  return request({
    url: `/tenant/organizations/${domainId}/invitedToJoinQueues/search`,
    method: "post",
    data,
  });
}
