import request from "@/api/request";
import requestAccess from "@/api/requestAccess";

//获取驻勤点类型
export function getAllStationTypes(params) {
  return request({
    url: "/security-stations/station-types",
    method: "GET",
    params,
  });
}

//获取驻勤点信息
export function getStations(data) {
  return request({
    url: "/security-stations/search",
    method: "POST",
    data,
  });
}

//获取驻勤点详细信息
export function getStationDetail(stationId) {
  return request({
    url: "/security-stations/" + stationId,
    method: "GET",
  });
}
export function getStationDetailAccess(stationId) {
  return requestAccess({
    url: "/security-stations/" + stationId,
    method: "GET",
  });
}
