import axios from "axios";

// 创建axios实例
const instance = axios.create({
  // axios中请求配置有baseURL选项，表示请求URL公共部分
  baseURL: process.env.VUE_APP_API_ROOT,
  timeout: 10000,
});
instance.interceptors.request.use(
  async (config) => {
    let urlStr = window.location.href.split("?")[1];
    const params = new URLSearchParams(urlStr);
    console.log(params)
    let accessToken = params.get("accessToken");
    if (accessToken) {
      config.headers.accessToken = accessToken;
    }
    return config;
  },
  (err) => {
    return Promise.reject(err);
  }
);

instance.interceptors.response.use((response) => {
  const { status, data } = response;
  if (status === 200) {
    const { url } = response.config;
    if (url.indexOf("json") > -1) {
      // mock api
      return data;
    } else {
      return data.data;
    }
  }
});

export default instance;
