import Vue from "vue";
import VueRouter from "vue-router";

Vue.use(VueRouter);

export const constantRouterMap = [
  {
    path: "/rail",
    name: "rail",
    component: () => import("@/views/rail/index.vue"),
  },
  {
    path: "*",
    redirect: "/rail",
  },
];

const originalPush = VueRouter.prototype.push;
VueRouter.prototype.push = function push(location) {
  return originalPush.call(this, location).catch((err) => err);
};

const router = new VueRouter({
  mode: "hash",
  base: process.env.BASE_URL,
  routes: constantRouterMap,
});

export default router;
