import Vue from "vue";
import App from "./App.vue";
import router from "./router";
import store from "./store";
import ElementUI from "element-ui"; // elementUI
// import TIM from "tim-js-sdk/tim-js-friendship";
import "element-ui/lib/theme-chalk/index.css";
import "normalize.css";
import "@/styles/index.scss"; // 公共样式
// import "@/api/auth";
import "@/utils/directive"; // 拖拽弹窗，在需要用到拖拽功能的弹窗标签上加v-dialogDrag
import drag from '@/utils/drag';

Vue.prototype.$store = store;
// Vue.prototype.TIM = TIM;
Vue.prototype.$bus = new Vue(); // event Bus 用于无关系组件间的通信。

Vue.config.productionTip = false;

Vue.directive('drag', drag)

Vue.use(ElementUI, {
  size: "medium",
});

new Vue({
  router,
  store,
  render: (h) => h(App),
}).$mount("#app");
