package com.bcxin.message.strategy.message;

import cn.wildfirechat.pojos.Conversation;
import com.bcxin.message.common.CommonConstant;
import com.bcxin.message.common.utils.SpringContextUtils;
import com.bcxin.message.strategy.message.impl.ChannelSendTextMsg;
import com.bcxin.message.strategy.message.impl.RobotSendLinkMsg;
import com.bcxin.message.strategy.message.impl.RobotSendNoticeMsg;
import com.bcxin.message.strategy.message.impl.RobotSendTextMsg;

/**
 * 发送消息策略工厂
 */
public class SendMessageStrategyFactory {

    /**
     * 根据发送类型和消息类型，获取机器人策略接口实现类
     */
    public static SendMessageStrategy getInstance(String senderType, String targetType, String messageType) {
        switch (senderType) {
            case CommonConstant.MSG_SEND_TYPE_ROBOT:
                //机器人
                switch (messageType) {
                    case CommonConstant.MSG_MESSAGE_TYPE_TEXT:
                        //发送用户文本消息
                        return SpringContextUtils.getBean(RobotSendTextMsg.class);
                    case CommonConstant.MSG_MESSAGE_TYPE_LINK:
                        //发送用户链接消息
                        return SpringContextUtils.getBean(RobotSendLinkMsg.class);
                    case CommonConstant.MSG_MESSAGE_TYPE_NOTICE:
                        //发送用户链接消息
                        return SpringContextUtils.getBean(RobotSendNoticeMsg.class);
                }
            case CommonConstant.MSG_SEND_TYPE_CHANNEL:
                //频道
                switch (messageType) {
                    case CommonConstant.MSG_MESSAGE_TYPE_TEXT:
                        //发送用户文本消息
                        return SpringContextUtils.getBean(ChannelSendTextMsg.class);
                }

        }
        throw new RuntimeException(String.format("机器人策略工厂：获取策略异常，senderType：%s，targetType：%s，messageType：%s",
                senderType, targetType, messageType));
    }

    /**
     * description：获取统一会话
     * author：linchunpeng
     * date：2025/7/15
     */
    public static Conversation getConversation(String targetType, String targetId) {
        //会话
        Conversation conversation = new Conversation();
        //会话类型，0一对一的会话类型，1群组会话类型，2聊天室会话类型，3一对多的会话类型，5密聊会话类型
        if (targetType.equals(CommonConstant.MSG_TARGET_TYPE_GROUP)) {
            conversation.setType(1);
        } else if (targetType.equals(CommonConstant.MSG_TARGET_TYPE_USER)) {
            conversation.setType(0);
        }
        conversation.setTarget(targetId);
        //会话线路，会话线路可以更加方便的过滤会话
        //比如同一个app中不同部门可以使用不同的line区分
        // 或者可以设计不同的场景使用不同的line等
        // 如果没有这种特殊需求，使用0值就可以
        conversation.setLine(0);
        return conversation;
    }
}
