package com.bcxin.message.service.messagecenter;

import cn.wildfirechat.common.ErrorCode;
import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.pojos.OutputCreateGroupResult;
import cn.wildfirechat.pojos.PojoGroupInfo;
import cn.wildfirechat.pojos.PojoGroupMember;
import cn.wildfirechat.sdk.GroupAdmin;
import cn.wildfirechat.sdk.model.IMResult;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.message.common.emus.MsgGroupCreateStatus;
import com.bcxin.message.common.emus.MsgSendRequestStatus;
import com.bcxin.message.dao.mapper.messagecenter.MsgGroupCreateMapper;
import com.bcxin.message.dtos.kafka.message.MsgGroupCreateKafkaMessage;
import com.bcxin.message.entity.messagecenter.MsgGroupCreateEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * description：群组创建表 service
 * author：linchunpeng
 * date：2025/7/9
 */
@Slf4j
@Service
public class MsgGroupCreateService extends ServiceImpl<MsgGroupCreateMapper, MsgGroupCreateEntity> {

   /**
    * description：更新创建状态
    * author：linchunpeng
    * date：2025/8/26
    */
    @Transactional
    public void updateCreateStatus(Long id, String groupId, MsgGroupCreateStatus status) {
        this.lambdaUpdate()
                .eq(MsgGroupCreateEntity::getId, id)
                .set(MsgGroupCreateEntity::getStatus, status.getCode())
                .set(MsgGroupCreateEntity::getGroupId, groupId)
                .set(MsgGroupCreateEntity::getUpdateTime, new Date())
                .update();
    }

    /**
     * description：创建野火im群组
     * author：linchunpeng
     * date：2025/8/26
     */
    public void createGroup(MsgGroupCreateKafkaMessage kafkaMessage) {
        try {
            log.info("创建群组，id：{}", kafkaMessage.getId());
            //操作者用户ID
            String operator = kafkaMessage.getOperator();
            //群参数，建议不填写群ID，由系统自动生成
            PojoGroupInfo group_info = JSONObject.parseObject(kafkaMessage.getGroupInfo(), PojoGroupInfo.class);
            group_info.setType(2);
            //群组成员列表
            List<PojoGroupMember> members = JSONObject.parseArray(kafkaMessage.getMembers(), PojoGroupMember.class);
            String member_extra = null;
            List<Integer> to_lines = null;//会话线路，默认为0
            MessagePayload notify_message = null;//消息负载，如果不填写，系统会发出内置通知消息，如果填写，覆盖系统通知消息
            IMResult<OutputCreateGroupResult> createResult = GroupAdmin.createGroup(operator, group_info, members, member_extra, to_lines, notify_message);
            String result = JSONObject.toJSONString(createResult);
            int sendSuccess = 0;
            String groupId = null;
            log.info("创建群组，id：{}，群组名称：{}，请求结果：{}", kafkaMessage.getId(), group_info.getName(), result);
            if (createResult != null && createResult.getErrorCode() == ErrorCode.ERROR_CODE_SUCCESS) {
                log.info("创建群组，id：{}，群组名称：{}，创建成功", kafkaMessage.getId(), group_info.getName());
                sendSuccess = 1;
                groupId = createResult.getResult().getGroup_id();
            } else {
                log.info("创建群组，id：{}，群组名称：{}，创建失败", kafkaMessage.getId(), group_info.getName());
            }
            this.updateCreateStatus(kafkaMessage.getId(), groupId, sendSuccess == 1 ? MsgGroupCreateStatus.SUCCESS : MsgGroupCreateStatus.FAIL);
        } catch (Exception e) {
            log.error("创建野火im群组异常，{}", e.getMessage(), e);
        }
    }

}
